/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crcb.dc.payment.individual;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.crcb.dc.helper.BankCode;
import kd.ebg.aqap.banks.crcb.dc.helper.JDOMHelper;
import kd.ebg.aqap.banks.crcb.dc.helper.RequestPacker;
import kd.ebg.aqap.banks.crcb.dc.helper.ResponseParser;
import kd.ebg.aqap.banks.crcb.dc.payment.individual.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public String getDeveloper() {
        return "Kingdee.WangJinPing";
    }

    public String getBizCode() {
        return BankCode.PAY_FOR_SALARY_CODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5de5\u8d44\u4ee3\u53d1", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml;charset=UTF-8");
    }

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return RequestPacker.getPaySalaryMessage(bankPayRequest.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        Map<String, Object> resBankMessage = JDOMHelper.getBodyData(rspStr);
        Map<String, Object> map = ResponseParser.submitSalaryMessage(resBankMessage);
        ResponseParser.parserSalaryMessage(bankPayRequest.getPaymentInfoAsArray(), rspStr, map);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

