/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.dc.service.payment.allocation.transdown;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xmb.dc.Packer;
import kd.ebg.aqap.banks.xmb.dc.Parser;
import kd.ebg.aqap.banks.xmb.dc.service.loginout.LoginAndOut;
import kd.ebg.aqap.banks.xmb.dc.service.payment.allocation.transdown.QueryPayImpl;
import kd.ebg.aqap.banks.xmb.dc.service.sign.SignService;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public String getDeveloper() {
        return "mukan_huang";
    }

    public String getBizCode() {
        return "CBE010";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u96c6\u56e2\u4e0b\u62e8", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]);
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u96c6\u56e2\u4e0b\u62e8\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]));
        }
        Element XCCBEBankData = new Element("XCCBEBankData");
        Element opReq = JDomUtils.addChild((Element)XCCBEBankData, (String)"opReq");
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)paymentInfos[0].getPackageId());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDateTime((Date)new Date()));
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"FKZH", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"SKZH", (String)paymentInfos[0].getIncomeAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"SKHM", (String)paymentInfos[0].getIncomeAccName());
        JDomUtils.addChild((Element)ReqParam, (String)"JYJE", (String)paymentInfos[0].getAmount().toString());
        JDomUtils.addChild((Element)ReqParam, (String)"BIZH", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)ReqParam, (String)"YOTU", (String)paymentInfos[0].getExplanation());
        String xmlMessage = Packer.packFormatXmlMsg(XCCBEBankData, "GBK");
        String signData = SignService.sign(xmlMessage);
        String sessionId = LoginAndOut.getLoginAndOut().getLoginSessionId();
        return Packer.packAll(sessionId, "CBE010", signData);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfoList = bankPayRequest.getPaymentInfos();
        PaymentInfo[] paymentInfos = paymentInfoList.toArray(new PaymentInfo[paymentInfoList.size()]);
        EBBankPayResponse response = new EBBankPayResponse();
        Parser.parsePayRsp(paymentInfos, s);
        response.setPaymentInfos(Arrays.asList(paymentInfos));
        return response;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml;charset=GBK");
    }
}

