/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.szsrcb.cmp.services.payment;

import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.szsrcb.cmp.services.Common;
import kd.ebg.aqap.banks.szsrcb.cmp.services.Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPay
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        String tr_code = "03020104A0239";
        String req_no = Sequence.genSequence();
        Element ap = Packer.createCommonHead(tr_code, req_no, "0");
        Element body = ap.getChild("body");
        String d = LocalDateUtil.formatDate((LocalDateTime)paymentInfos[0].getSubmitSuccessTime());
        JDomUtils.addChild((Element)body, (String)"reqDate", (String)d);
        JDomUtils.addChild((Element)body, (String)"reqSerialNo", (String)paymentInfos[0].getBankBatchSeqId());
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return Common.createCommonMsg(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List infos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPay_0", (String)"ebg-aqap-banks-szsrcb-cmp", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return new EBBankPayResponse(infos);
        }
        Element body = ap.getChild("body");
        String stat = body.getChildTextTrim("busiStat");
        String jnlMsg = body.getChildTextTrim("jnlMsg");
        if ("S".equals(stat)) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPay_1", (String)"ebg-aqap-banks-szsrcb-cmp", (Object[])new Object[0]), (String)stat, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPay_1", (String)"ebg-aqap-banks-szsrcb-cmp", (Object[])new Object[0]));
        } else if ("F".equals(stat)) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPay_2", (String)"ebg-aqap-banks-szsrcb-cmp", (Object[])new Object[0]), (String)stat, (String)jnlMsg);
        } else if ("P".equals(stat) || "A".equals(stat)) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPay_3", (String)"ebg-aqap-banks-szsrcb-cmp", (Object[])new Object[0]), (String)stat, (String)jnlMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPay_0", (String)"ebg-aqap-banks-szsrcb-cmp", (Object[])new Object[0]), (String)stat, (String)jnlMsg);
        }
        return new EBBankPayResponse(infos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}

