/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ncb.dc.payment.samebank;

import java.math.BigDecimal;
import java.util.Arrays;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ncb.dc.helper.Constant;
import kd.ebg.aqap.banks.ncb.dc.helper.Parser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public final class QueryPayParser {
    private static String[] submiteds = new String[]{"4", "5", "7", "9", "17", "18", "19", "20", "21", "22", "23", "24"};

    public void parseQueryPay(PaymentInfo[] paymentInfos, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parserCommonInfo(root);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u5931\u8d25 :%1$s", (String)"QueryPayParser_6", (String)"ebg-aqap-banks-ncb-dc", (Object[])new Object[0]), bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"body");
        String status = JDomUtils.getChildText((Element)resBody, (String)"pay_status");
        this.check(paymentInfo, resBody);
        if ("1".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)status, (String)Constant.PAYSTATUSMAP.get(status));
        } else if ("2".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)status, (String)Constant.PAYSTATUSMAP.get(status));
        } else if (Arrays.asList(submiteds).contains(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)status, (String)Constant.PAYSTATUSMAP.get(status));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)status, (String)Constant.PAYSTATUSMAP.get(status));
        }
    }

    private void check(PaymentInfo paymentInfo, Element resBody) {
        String msg = "";
        if (!paymentInfo.getAmount().equals(new BigDecimal(JDomUtils.getChildText((Element)resBody, (String)"pay_amount")))) {
            msg = String.format(ResManager.loadKDString((String)"\u91d1\u989d\u4e0d\u5339\u914d\uff1a%1$s\uff0c%2$s\u3002", (String)"QueryPayParser_7", (String)"ebg-aqap-banks-ncb-dc", (Object[])new Object[0]), paymentInfo.getAmount(), JDomUtils.getChildText((Element)resBody, (String)"pay_amount"));
        }
        if (!paymentInfo.getAccNo().equals(JDomUtils.getChildText((Element)resBody, (String)"payer_acct_no"))) {
            msg = msg + String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u4e0d\u5339\u914d\uff1a%1$s\uff0c%2$s\u3002", (String)"QueryPayParser_8", (String)"ebg-aqap-banks-ncb-dc", (Object[])new Object[0]), paymentInfo.getAccNo(), JDomUtils.getChildText((Element)resBody, (String)"payer_acct_no"));
        }
        if (!paymentInfo.getIncomeAccNo().equals(JDomUtils.getChildText((Element)resBody, (String)"payee_acct_no"))) {
            msg = msg + String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7\u4e0d\u5339\u914d\uff1a%1$s\uff0c%2$s\u3002", (String)"QueryPayParser_9", (String)"ebg-aqap-banks-ncb-dc", (Object[])new Object[0]), paymentInfo.getIncomeAccNo(), JDomUtils.getChildText((Element)resBody, (String)"payee_acct_no"));
        }
        if (!paymentInfo.getIncomeAccName().equals(JDomUtils.getChildText((Element)resBody, (String)"payee_acct_name"))) {
            msg = msg + String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u6237\u540d\u4e0d\u5339\u914d\uff1a%1$s\uff0c%2$s\u3002", (String)"QueryPayParser_10", (String)"ebg-aqap-banks-ncb-dc", (Object[])new Object[0]), paymentInfo.getIncomeAccName(), JDomUtils.getChildText((Element)resBody, (String)"payee_acct_name"));
        }
        if (!StringUtils.isEmpty((String)msg)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\uff1a%1$s\u3002", (String)"QueryPayParser_11", (String)"ebg-aqap-banks-ncb-dc", (Object[])new Object[0]), msg));
        }
    }
}

