/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.kit;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.ClassPathResource;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class FailCode {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(FailCode.class);
    public static final String fileName = "failCode.xls";
    public static FailCode instance;
    private Map<String, String> failCodeMap;

    public static FailCode getInstance() {
        if (null == instance) {
            instance = new FailCode();
        }
        return instance;
    }

    private FailCode() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.failCodeMap = new HashMap<String, String>(16);
        InputStream is = null;
        HSSFWorkbook workbook = null;
        try {
            is = new ClassPathResource(fileName).getInputStream();
            workbook = new HSSFWorkbook(is);
            this.read2Map(workbook, this.failCodeMap);
        }
        catch (Exception e1) {
            logger.error("\u8bfb\u53d6\u4ea4\u6613\u5931\u8d25\u72b6\u6001\u7801\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e1);
        }
        finally {
            if (null != is) {
                try {
                    if (null != workbook) {
                        workbook.close();
                    }
                    is.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    private void read2Map(HSSFWorkbook workbook, Map<String, String> failCodeMap) {
        HSSFSheet sheet = workbook.getSheetAt(0);
        int lastRowNum = sheet.getLastRowNum();
        for (int startRow = 1; startRow < lastRowNum; ++startRow) {
            HSSFRow row = sheet.getRow(startRow);
            HSSFCell cell0 = row.getCell(0);
            HSSFCell cell1 = row.getCell(1);
            failCodeMap.put(cell0.getStringCellValue().trim(), cell1.getStringCellValue().trim());
        }
    }

    public boolean isFail(String errorCode) {
        return this.failCodeMap.containsKey(errorCode);
    }
}

