/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.payment.linkpay;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.kit.FailCode;
import kd.ebg.aqap.banks.boc.net.service.BocNetUtils;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.banks.boc.net.service.payment.linkpay.LinkQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.INativeLinkPayable;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFieldConstants;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class LinkPayImpl
extends AbstractPayImpl
implements IPay,
INativeLinkPayable {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(LinkQueryPayImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public int getBatchSize() {
        if (BankBusinessConfig.isB2e0017LinkpayType()) {
            return 100;
        }
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return LinkQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "jianbo_chen";
    }

    public String getBizCode() {
        return "b2e0020 & b2e0017";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8 - trn-b2e0020-rq ,\u65b0\u7528\u6237\u4f7f\u7528-b2e0017\u63a5\u53e3", (String)"LinkPayImpl_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (BankBusinessConfig.isB2e0017LinkpayType()) {
            return this.packb2e0017Xml(paymentInfos);
        }
        return this.packb2e0020Xml(paymentInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String packb2e0020Xml(List<PaymentInfo> paymentInfos) throws EBServiceException {
        PaymentInfo paymentInfo = paymentInfos.get(0);
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
        }
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0020");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element action = JDomUtils.addChild((Element)trans, (String)"trn-b2e0020-rq");
            Element record = JDomUtils.addChild((Element)action, (String)"b2e0020-rq");
            paymentInfo.setBankRefID(BocNetUtils.getBankDetailSeqId(paymentInfo));
            JDomUtils.addChild((Element)record, (String)"insid", (String)BocNetUtils.getInsid(paymentInfo));
            BocNetUtils.batchSetReservedSysField(paymentInfos, PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID, BocNetUtils.getSeqIdFromInsid(paymentInfo.getBankDetailSeqId()));
            String grpidt = RequestContextUtils.getBankParameterValue((String)"grpidt");
            JDomUtils.addChild((Element)record, (String)"grpidt", (String)grpidt);
            BankAcntService acntService = BankAcntService.getInstance();
            BankAcnt parentAcc = acntService.selectByCustomIDAndAccNo(paymentInfo.getThirdAccNo(), paymentInfo.getCustomID());
            if (StringUtils.isEmpty((String)parentAcc.getAreaCode())) {
                logger.info("\u4e2d\u884c\u8054\u52a8\u652f\u4ed8\u529f\u80fd\u9700\u8981\u5728\u94f6\u4f01\u4e91\u4e2d\u7ef4\u62a4\u6bcd\u8d26\u53f7(" + paymentInfo.getThirdAccNo() + ")\u7684\u5bf9\u5e945\u4f4d\u5730\u533a\u7801\u3002");
            }
            Element fractn = JDomUtils.addChild((Element)record, (String)"fractn");
            JDomUtils.addChild((Element)fractn, (String)"fribkn", (String)parentAcc.getAreaCode());
            JDomUtils.addChild((Element)fractn, (String)"actacn", (String)parentAcc.getAccNo());
            JDomUtils.addChild((Element)fractn, (String)"actnam", (String)parentAcc.getAccName());
            Element mdactn = JDomUtils.addChild((Element)record, (String)"mdactn");
            BankAcnt payerAcc = acntService.selectByCustomIDAndAccNo(paymentInfo.getAccNo(), paymentInfo.getCustomID());
            if (StringUtils.isEmpty((String)payerAcc.getAreaCode()) && StringUtils.isEmpty((String)paymentInfo.getAreaCode())) {
                logger.info("\u4e2d\u884c\u8054\u52a8\u652f\u4ed8\u529f\u80fd\u9700\u8981\u5728\u94f6\u4f01\u4e91\u4e2d\u7ef4\u62a4\u5b50\u8d26\u53f7(" + paymentInfo.getAccNo() + ")\u76845\u4f4d\u5730\u533a\u7801\u3002");
            }
            if (!StringUtils.isEmpty((String)payerAcc.getAreaCode())) {
                JDomUtils.addChild((Element)mdactn, (String)"mdibkn", (String)payerAcc.getAreaCode());
            } else {
                JDomUtils.addChild((Element)mdactn, (String)"mdibkn", (String)paymentInfo.getAreaCode());
            }
            JDomUtils.addChild((Element)mdactn, (String)"actacn", (String)payerAcc.getAccNo());
            JDomUtils.addChild((Element)mdactn, (String)"actnam", (String)payerAcc.getAccName());
            Element toactn = JDomUtils.addChild((Element)record, (String)"toactn");
            if (paymentInfo.is2SameBank()) {
                JDomUtils.addChild((Element)toactn, (String)"toibkn", (String)paymentInfo.getIncomeAreaCode());
            } else {
                JDomUtils.addChild((Element)toactn, (String)"toibkn", (String)paymentInfo.getIncomeCnaps());
            }
            JDomUtils.addChild((Element)toactn, (String)"actacn", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)toactn, (String)"toname", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)toactn, (String)"toaddr", (String)paymentInfo.getIncomeCity());
            JDomUtils.addChild((Element)toactn, (String)"tobknm", (String)paymentInfo.getIncomeBankName());
            BigDecimal amount = paymentInfo.getAmount().setScale(2, 4);
            JDomUtils.addChild((Element)record, (String)"trnamt", (String)amount.toString().trim());
            JDomUtils.addChild((Element)record, (String)"trncur", (String)paymentInfo.getCurrency());
            JDomUtils.addChild((Element)record, (String)"priolv", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
            JDomUtils.addChild((Element)record, (String)"furinfo", (String)paymentInfo.getExplanation());
            JDomUtils.addChild((Element)record, (String)"trfdate", (String)DateUtil.formatDate((Date)new Date()));
            JDomUtils.addChild((Element)record, (String)"comacn", (String)"");
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String packb2e0017Xml(List<PaymentInfo> paymentInfos) throws EBServiceException {
        LoginAccess la = LoginAccessManager.searchLock();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID(paymentInfos);
        }
        try {
            String token = la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0017");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element action = JDomUtils.addChild((Element)trans, (String)"trn-b2e0017-rq");
            JDomUtils.addChild((Element)action, (String)"ceitinfo");
            for (int i = 0; i < paymentInfos.size(); ++i) {
                PaymentInfo info = paymentInfos.get(i);
                Element record = JDomUtils.addChild((Element)action, (String)"b2e0017-rq");
                info.setBankRefID(BocNetUtils.getBankDetailSeqId(info));
                JDomUtils.addChild((Element)record, (String)"insid", (String)BocNetUtils.getInsid(info));
                BocNetUtils.batchSetReservedSysField(paymentInfos, PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID, BocNetUtils.getSeqIdFromInsid(info.getBankDetailSeqId()));
                String grpidt = RequestContextUtils.getBankParameterValue((String)"grpidt");
                JDomUtils.addChild((Element)record, (String)"grpidt", (String)grpidt);
                BankAcntService acntService = BankAcntService.getInstance();
                BankAcnt parentAcc = acntService.selectByCustomIDAndAccNo(info.getThirdAccNo(), info.getCustomID());
                if (StringUtils.isEmpty((String)parentAcc.getAreaCode())) {
                    logger.info("\u4e2d\u884c\u8054\u52a8\u652f\u4ed8\u529f\u80fd\u9700\u8981\u5728\u94f6\u4f01\u4e91\u4e2d\u7ef4\u62a4\u6bcd\u8d26\u53f7(" + info.getThirdAccNo() + ")\u7684\u5bf9\u5e945\u4f4d\u5730\u533a\u7801\u3002");
                }
                Element fractn = JDomUtils.addChild((Element)record, (String)"fractn");
                JDomUtils.addChild((Element)fractn, (String)"fribkn", (String)parentAcc.getAreaCode());
                JDomUtils.addChild((Element)fractn, (String)"actacn", (String)parentAcc.getAccNo());
                Element mdactn = JDomUtils.addChild((Element)record, (String)"mdactn");
                BankAcnt payerAcc = acntService.selectByCustomIDAndAccNo(info.getAccNo(), info.getCustomID());
                if (StringUtils.isEmpty((String)payerAcc.getAreaCode()) && StringUtils.isEmpty((String)info.getAreaCode())) {
                    logger.info("\u4e2d\u884c\u8054\u52a8\u652f\u4ed8\u529f\u80fd\u9700\u8981\u5728\u94f6\u4f01\u4e91\u4e2d\u7ef4\u62a4\u5b50\u8d26\u53f7(" + info.getAccNo() + ")\u76845\u4f4d\u5730\u533a\u7801\u3002");
                }
                if (!StringUtils.isEmpty((String)payerAcc.getAreaCode())) {
                    JDomUtils.addChild((Element)mdactn, (String)"mdibkn", (String)payerAcc.getAreaCode());
                } else {
                    JDomUtils.addChild((Element)mdactn, (String)"mdibkn", (String)info.getAreaCode());
                }
                JDomUtils.addChild((Element)mdactn, (String)"actacn", (String)payerAcc.getAccNo());
                Element toactn = JDomUtils.addChild((Element)record, (String)"toactn");
                if (info.is2SameBank()) {
                    JDomUtils.addChild((Element)toactn, (String)"toibkn", (String)info.getIncomeAreaCode());
                } else {
                    JDomUtils.addChild((Element)toactn, (String)"toibkn", (String)info.getIncomeCnaps());
                }
                JDomUtils.addChild((Element)toactn, (String)"actacn", (String)info.getIncomeAccNo());
                JDomUtils.addChild((Element)toactn, (String)"toname", (String)info.getIncomeAccName());
                JDomUtils.addChild((Element)toactn, (String)"toaddr", (String)info.getIncomeCity());
                BigDecimal amount = info.getAmount().setScale(2, 4);
                JDomUtils.addChild((Element)record, (String)"trnamt", (String)amount.toString().trim());
                JDomUtils.addChild((Element)record, (String)"trncur", (String)info.getCurrency());
                JDomUtils.addChild((Element)record, (String)"priolv", (String)(info.is2Urgent() ? "1" : "0"));
                JDomUtils.addChild((Element)record, (String)"cuspriolv", (String)(info.is2Urgent() ? "1" : "0"));
                JDomUtils.addChild((Element)record, (String)"useinf", (String)info.getExplanation());
                JDomUtils.addChild((Element)record, (String)"furinfo", (String)info.getExplanation());
                JDomUtils.addChild((Element)record, (String)"trfdate", (String)DateUtil.formatDate((Date)new Date()));
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        if (BankBusinessConfig.isB2e0017LinkpayType()) {
            this.parsePay(paymentInfos, responseStr, "b2e0017-rs");
        } else {
            this.parsePay(paymentInfos, responseStr, "b2e0020-rs");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private void parsePay(List<PaymentInfo> paymentInfos, String rspStr, String transresp) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        boolean isError = Parser.parserB2eError(root, paymentInfos);
        if (isError) {
            return;
        }
        Element trans = root.getChild("trans");
        Element action = (Element)trans.getChildren().get(0);
        Element status = action.getChild("status");
        String rspCode = status.getChildTextTrim("rspcod");
        String rspMsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspCode);
        if ("1011".equalsIgnoreCase(rspCode)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)rspCode, (String)rspMsg);
            return;
        }
        if (!"B001".equalsIgnoreCase(rspCode)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rspCode, (String)rspMsg);
        } else {
            List records = action.getChildren(transresp);
            if (records != null && records.size() > 0) {
                for (int i = 0; i < records.size(); ++i) {
                    Element record = (Element)records.get(i);
                    status = record.getChild("status");
                    rspCode = status.getChildTextTrim("rspcod");
                    rspMsg = status.getChildTextTrim("rspmsg");
                    if ("B001".equalsIgnoreCase(rspCode)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.SUBMITED, (String)"", (String)rspCode, (String)rspMsg);
                        continue;
                    }
                    if ("1014".equalsIgnoreCase(rspCode)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rspCode, (String)rspMsg);
                        continue;
                    }
                    if (FailCode.getInstance().isFail(rspCode)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.FAIL, (String)"", (String)rspCode, (String)rspMsg);
                        continue;
                    }
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"LinkPayImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)rspCode, (String)rspMsg);
                }
            }
        }
    }
}

