/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.ecny.service.payment.withdrawal;

import java.io.OutputStream;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.ecny.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.ecny.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.ecny.service.payment.etoe.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.INativeLinkPayable;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay,
INativeLinkPayable {
    public void closeOutputStreamQuietly(OutputStream outputStream) {
        IOUtils.closeOutputStreamQuietly((OutputStream)outputStream);
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "CMRB27/CMRB28";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6570\u5e01\u63d0\u73b0\uff1a\u672c\u884c\u5bf9\u516c\u94b1\u5305\u8f6c\u672c\u884c\u5bf9\u516c\u8d26\u6237-CMRB27 \u672c\u884c\u5bf9\u516c\u94b1\u5305\u8f6c\u4ed6\u884c\u5bf9\u516c\u8d26\u6237-CMRB28\u3002", (String)"PayImpl_5", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return false;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (paymentInfo.is2SameBank()) {
            Element root = ABC_DC_Packer.createABCRoot4New("CMRB27", paymentInfo.getBankBatchSeqID());
            Element dcep = JDomUtils.addChild((Element)root, (String)"Dcep");
            JDomUtils.addChild((Element)dcep, (String)"dbAccNo", (String)paymentInfo.getAccNo());
            JDomUtils.addChild((Element)dcep, (String)"dbAccName", (String)paymentInfo.getAccName());
            JDomUtils.addChild((Element)dcep, (String)"crAccNo", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)dcep, (String)"crAccName", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)dcep, (String)"transAmt", (String)paymentInfo.getAmount().setScale(2, 4).toString());
            JDomUtils.addChild((Element)dcep, (String)"curCode", (String)"CNY");
            JDomUtils.addChild((Element)dcep, (String)"transAbs", (String)paymentInfo.getExplanation());
            return ABC_DC_Packer.covert2ABCMessage(root);
        }
        Element root = ABC_DC_Packer.createABCRoot4New("CMRB28", paymentInfo.getBankDetailSeqId());
        Element dcep = JDomUtils.addChild((Element)root, (String)"Dcep");
        JDomUtils.addChild((Element)dcep, (String)"dbAccNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)dcep, (String)"dbAccName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)dcep, (String)"dbBranchNo", (String)paymentInfo.getIncomeBranchNo());
        JDomUtils.addChild((Element)dcep, (String)"crAccNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)dcep, (String)"crAccName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)dcep, (String)"transAmt", (String)paymentInfo.getAmount().setScale(2, 4).toString());
        JDomUtils.addChild((Element)dcep, (String)"curCode", (String)"CNY");
        JDomUtils.addChild((Element)dcep, (String)"transAbs", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)dcep, (String)"trxPrps", (String)"TF99");
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = ABC_DC_Parser.parseString2Root(responseStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (StringUtils.isEmpty((String)rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u4e0d\u5b58\u5728RespCode\u8282\u70b9\u6216\u8be5\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"PayImpl_1", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        if ("0000".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"PayImpl_2", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]), (String)"", (String)"");
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u3002", (String)"PayImpl_3", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

