/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.njb.dc.services.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.njb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.njb.dc.services.proxy.FileProxy;
import kd.ebg.aqap.banks.njb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.njb.dc.utils.TCommon;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.DetailFieldUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailFieldConf;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailParser {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailParser.class);
    private static final DetailParser instance = new DetailParser();

    public static DetailParser getInstance() {
        return instance;
    }

    private DetailInfo parseRecord(String[] r2_k, Map<String, Integer> countMap, DetailFieldConf detailField) throws EBServiceException {
        DetailInfo detailInfo = new DetailInfo();
        String cur_code = r2_k[2];
        detailInfo.setCurrency(cur_code);
        String oppacno = r2_k[8];
        detailInfo.setOppAccNo(oppacno);
        String oppacname = r2_k[10];
        detailInfo.setOppAccName(oppacname);
        String accountOpenNode = r2_k[11];
        detailInfo.setOppBankName(accountOpenNode);
        String acno = r2_k[1];
        detailInfo.setAccNo(acno);
        String acname = r2_k[7];
        detailInfo.setAccName(acname);
        String transDateStr = r2_k[3] + r2_k[4];
        Date transDatetime = DateUtil.String2Date((String)transDateStr);
        detailInfo.setTransDate(kd.ebg.aqap.banks.njb.dc.utils.DateUtil.dateTolocalDate(transDatetime));
        detailInfo.setTransTime(kd.ebg.aqap.banks.njb.dc.utils.DateUtil.dateTolocalDateTime(transDatetime));
        String payAmount = r2_k[40];
        String recAmount = r2_k[41];
        String CDFlag = r2_k[23];
        String purpose = r2_k[34];
        if (BankBusinessConfig.isAddKDFlag().booleanValue() && purpose.contains("_KD_")) {
            String id = BizNoUtil.getId((String)purpose);
            detailInfo.setKdFlag(id);
            detailInfo.setPayBankDetailSeqID(id);
        }
        BigDecimal payAmountD = new BigDecimal(payAmount);
        BigDecimal recAmountD = new BigDecimal(recAmount);
        if (CDFlag.equalsIgnoreCase("D")) {
            detailInfo.setDebitAmount(payAmountD);
            detailInfo.setCreditAmount(new BigDecimal(0));
        } else if (CDFlag.equalsIgnoreCase("C")) {
            detailInfo.setDebitAmount(new BigDecimal(0));
            detailInfo.setCreditAmount(recAmountD);
        } else {
            detailInfo.setDebitAmount(payAmountD);
            detailInfo.setCreditAmount(recAmountD);
        }
        String AcctBal = r2_k[25];
        BigDecimal balance = new BigDecimal(AcctBal);
        detailInfo.setBalance(balance);
        String summary = r2_k[34];
        String postscript = r2_k[35];
        detailInfo.setExplanation(summary);
        JSONObject jsonObject = new JSONObject();
        String json = null;
        if (detailField != null) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < r2_k.length; ++j) {
                sb.append(r2_k[j]).append(detailField.getSplit());
            }
            json = MatchRule.getInstance().getDetailJsonWithNonStructuredData(detailField.getDetailFields(), sb.toString(), detailField.getSplit());
        }
        if (StringUtils.isNotEmpty(json)) {
            jsonObject = JSON.parseObject(json);
        }
        jsonObject.put("tr_acdt", (Object)r2_k[3]);
        jsonObject.put("host_serial_no", (Object)r2_k[5]);
        jsonObject.put("host_serial_no2", (Object)(!r2_k[5].contains("-") ? r2_k[5] : r2_k[5].split("-")[0]));
        jsonObject.put("crdr_flag", (Object)CDFlag);
        jsonObject.put("crdr_flag2", (Object)("C".equalsIgnoreCase(CDFlag) ? "1" : "0"));
        jsonObject.put("amt", (Object)r2_k[24]);
        detailInfo.setJsonMap(jsonObject.toJSONString());
        detailInfo.setBankDetailNo(r2_k[5]);
        String receiptNo = MatchRule.getInstance().getReceiptNo(acno, detailInfo.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE), jsonObject.toJSONString());
        if (countMap.containsKey(receiptNo)) {
            int count = countMap.get(receiptNo) + 1;
            countMap.put(receiptNo, count);
            receiptNo = receiptNo + "-" + String.format("%04d", count);
        } else {
            countMap.put(receiptNo, 0);
        }
        detailInfo.setReceiptNo(receiptNo);
        return detailInfo;
    }

    public List<DetailInfo> parseTodayDetail(BankDetailRequest arg0, String arg1) throws EBServiceException {
        log.info("\u83b7\u53d6\u62a5\u6587\u7684\u65f6\u95f4\uff1a" + System.currentTimeMillis());
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        BankAcnt acnt = arg0.getAcnt();
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)TCommon.parseRecvMsg(arg1), (String)encoding);
        Element head = ebenk.getChild("head");
        if (!"0000".equals(head.getChildTextTrim("ret_code")) || !"0".equals(head.getChildTextTrim("succ_flag"))) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u672a\u80fd\u6b63\u5e38\u8fd4\u56de,\u8fd4\u56de\u7801\uff1a%1$s,\u8fd4\u56de\u9644\u52a0\u4fe1\u606f:%2$s", (String)"DetailParser_7", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), head.getChildTextTrim("ret_code"), head.getChildText("ext_info"));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = ebenk.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        String content = null;
        if (recordNum <= 0) {
            log.error("###\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u4ea4\u6613\u660e\u7ec6\u3002");
            return details;
        }
        if ("0".equals(head.getChildTextTrim("file_flag"))) {
            String serial_record;
            log.info("\u8fd4\u56de\u7684\u662f\u62a5\u6587\uff0c\u4eceserial_record\u91cc\u9762\u62ff\u5230\u4fe1\u606f");
            content = serial_record = body.getChildTextTrim("serial_record");
        } else if ("1".equals(head.getChildTextTrim("file_flag"))) {
            log.info("\u8fd4\u56de\u7684\u662f\u6587\u4ef6");
            String file_name = body.getChildTextTrim("file_name");
            content = new FileProxy().download(file_name);
        }
        String[][] rs = GLBParser.parseMFS(content, recordNum, fieldNum);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        DetailFieldConf detailField = DetailFieldUtil.getInstance().getDetailField(EBContext.getContext().getBankVersionID(), "200110");
        for (int k = 0; k < rs.length; ++k) {
            String[] rs_k = rs[k];
            DetailInfo detailInfo = this.parseRecord(rs_k, countMap, detailField);
            details.add(detailInfo);
        }
        log.info("===\u89e3\u6790<\u4ea4\u6613\u660e\u7ec6>\u62a5\u6587\u7ed3\u675f===");
        return details;
    }
}

