/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.smbcn.dc.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.smbcn.dc.SmbcnDcBankBusinessConfig;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PackerCommon {
    public static Element getHeaderElement(String transCode) {
        Element reqInfo = new Element("reqInfo");
        JDomUtils.addChild((Element)reqInfo, (String)"transCode", (String)transCode);
        JDomUtils.addChild((Element)reqInfo, (String)"verNo", (String)"1.0");
        JDomUtils.addChild((Element)reqInfo, (String)"corpNo", (String)RequestContextUtils.getBankParameterValue((String)"corpNo"));
        JDomUtils.addChild((Element)reqInfo, (String)"operater", (String)RequestContextUtils.getBankParameterValue((String)"operater"));
        JDomUtils.addChild((Element)reqInfo, (String)"vOperater", (String)RequestContextUtils.getBankParameterValue((String)"vOperater"));
        String prefix = DateTimeUtils.format((Date)new Date(), (String)"yyMMdd");
        JDomUtils.addChild((Element)reqInfo, (String)"pkgNo", (String)(prefix + Sequence.getAutoincrementNumber((int)6)));
        String date = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String timeStr = LocalDateTime.now().format(DateTimeFormatter.ofPattern("hh:mm:ss"));
        JDomUtils.addChild((Element)reqInfo, (String)"reqTime", (String)(date + "T" + timeStr));
        return reqInfo;
    }

    public static Element getReqElement(Element root, String transCode) {
        Element reqInfo = PackerCommon.getHeaderElement(transCode);
        JDomUtils.addChild((Element)root, (Element)reqInfo);
        Element req = new Element("req");
        JDomUtils.addChild((Element)root, (Element)req);
        return req;
    }

    public static Element getReqElement(String accno, String currency) {
        Element accPro = new Element("accPro");
        String brchCode = SmbcnDcBankBusinessConfig.getbrchCode(accno);
        if (StringUtils.isEmpty((String)brchCode)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u5206\u884c\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u8d26\u53f7\u9644\u52a0\u5c5e\u6027\u7ef4\u62a4\u3002", (String)"PackerCommon_0", (String)"ebg-aqap-banks-smbcn-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)accPro, (String)"brchCode", (String)brchCode);
        JDomUtils.addChild((Element)accPro, (String)"accNo", (String)accno);
        JDomUtils.addChild((Element)accPro, (String)"currCode", (String)currency);
        String glSubCode = SmbcnDcBankBusinessConfig.getGLSUBCD(accno);
        if (StringUtils.isEmpty((String)glSubCode)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d26\u53f7 GLSUBCD\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u8d26\u53f7\u9644\u52a0\u5c5e\u6027\u7ef4\u62a4\u3002", (String)"PackerCommon_1", (String)"ebg-aqap-banks-smbcn-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)accPro, (String)"glSubCode", (String)glSubCode);
        JDomUtils.addChild((Element)accPro, (String)"reserved1", (String)"");
        JDomUtils.addChild((Element)accPro, (String)"reserved2", (String)"");
        JDomUtils.addChild((Element)accPro, (String)"reserved3", (String)"");
        JDomUtils.addChild((Element)accPro, (String)"reserved4", (String)"");
        return accPro;
    }

    public static Element getOpAccProElement(PaymentInfo info) {
        Element opAccPro = new Element("opAccPro");
        JDomUtils.addChild((Element)opAccPro, (String)"accNo", (String)info.getIncomeAccNo());
        JDomUtils.addChild((Element)opAccPro, (String)"accName", (String)info.getIncomeAccName());
        JDomUtils.addChild((Element)opAccPro, (String)"bankName", (String)info.getIncomeBankName());
        if (StringUtils.isEmpty((String)info.getIncomeProvince())) {
            JDomUtils.addChild((Element)opAccPro, (String)"district", (String)ResManager.loadKDString((String)"\u5176\u4ed6", (String)"PackerCommon_2", (String)"ebg-aqap-banks-smbcn-dc", (Object[])new Object[0]));
        } else {
            JDomUtils.addChild((Element)opAccPro, (String)"district", (String)info.getIncomeProvince());
        }
        return opAccPro;
    }

    public static Element getBaseElement(Element root, String transCode, String accno, String currency) {
        Element req = PackerCommon.getReqElement(root, transCode);
        Element accPro = PackerCommon.getReqElement(accno, currency);
        JDomUtils.addChild((Element)req, (Element)accPro);
        return req;
    }
}

