/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc.service.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbl.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsbl.dc.service.HSBL_DC_Packer;
import kd.ebg.aqap.banks.hsbl.dc.service.HSBL_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public boolean match(BankBalanceRequest request) {
        return BankBusinessConfig.getBalanceMethod().equalsIgnoreCase("FILE");
    }

    public String getDeveloper() {
        return "mukan_huang";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d", (String)"BalanceImpl_11", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]);
    }

    public String pack(BankBalanceRequest rqst) {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = HSBL_DC_Packer.createHead("BALANCE");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"reqCount", (String)"1");
        LocalDate startDate = rqst.getStartDate();
        if (null == startDate) {
            startDate = LocalDate.now();
        }
        JDomUtils.addChild((Element)reqPara, (String)"balDate", (String)DateUtil.formatDate((LocalDate)startDate, (String)"yyyyMMdd"));
        Element list = JDomUtils.addChild((Element)reqPara, (String)"list");
        JDomUtils.addChild((Element)list, (String)"acntNo", (String)rqst.getAcnt().getAccNo());
        JDomUtils.addChild((Element)list, (String)"acntType", (String)"");
        JDomUtils.addChild((Element)list, (String)"currency", (String)rqst.getBankCurrency());
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        BankAcnt acnt = rqst.getAcnt();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = HSBL_DC_Parser.parseHeader(root);
        if (!"BIZ_SUCCESS".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25,%1$s,%2$s", (String)"BalanceImpl_27", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        List lists = rspPara.getChildren("list");
        if (null == lists || lists.size() < 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 ,list\u8282\u70b9\u4e3a\u7a7a", (String)"BalanceImpl_12", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
        }
        Element list = (Element)lists.get(0);
        Element status = JDomUtils.getChildElementNotNull((Element)list, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"BalanceImpl_13", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        String acNo = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"acntNo", (String)ResManager.loadKDString((String)"\u5e10\u53f7", (String)"BalanceImpl_14", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
        String currency = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"currency", (String)ResManager.loadKDString((String)"\u5e01\u79cd\u4ee3\u7801", (String)"BalanceImpl_15", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
        String bal = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"balance", (String)ResManager.loadKDString((String)"\u5e10\u6237\u4f59\u989d", (String)"BalanceImpl_16", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
        String availBal = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"aviBalance", (String)ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d", (String)"BalanceImpl_17", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
        String balDate = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"balDate", (String)ResManager.loadKDString((String)"\u4f59\u989d\u65e5\u671f", (String)"BalanceImpl_18", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
        String lastDayBalance = JDomUtils.getChildTextTrimNotNull((Element)list, (String)"lastDayBalance", (String)ResManager.loadKDString((String)"\u4e0a\u65e5\u4f59\u989d", (String)"BalanceImpl_19", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
        if (!acnt.getAccNo().equalsIgnoreCase(acNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 ,\u8fd4\u56de\u8d26\u53f7%1$s\u548c\u8bf7\u6c42\u8d26\u53f7%2$s\u4e0d\u4e00\u81f4.", (String)"BalanceImpl_29", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), acNo, acnt.getAccNo()));
        }
        if (!"BIZ_SUCCESS".equalsIgnoreCase(ReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 ,%1$s,%2$s", (String)"BalanceImpl_30", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
        BalanceInfo balance = new BalanceInfo();
        balance.setBankCurrency(currency);
        balance.setBankAcnt(rqst.getAcnt());
        balance.setCurrentBalance(new BigDecimal(bal));
        if (!StringUtils.isEmpty((String)availBal)) {
            balance.setAvailableBalance(new BigDecimal(availBal));
        }
        if (!StringUtils.isEmpty((String)lastDayBalance)) {
            balance.setLastDayAvlBalance(new BigDecimal(lastDayBalance));
        }
        try {
            balance.setBalanceDateTime(LocalDateTime.parse(balDate, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8d26\u6237\u4f59\u989d\u65f6\u95f4\u5f02\u5e38\u3002\u8fd4\u56de\u6570\u636e[%s]\u4e0d\u4e00\u81f4\u3002", (String)"BalanceImpl_31", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), balDate), (Throwable)e);
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }
}

