/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.mservice.boot.handler;

import com.alibaba.fastjson.JSONObject;
import com.google.common.io.Resources;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.core.event.EventManager;
import kd.ebg.aqap.common.utils.ClassUtil;
import kd.ebg.aqap.common.utils.ReflectUtil;
import kd.ebg.aqap.mservice.boot.handler.EBServiceHandler;
import kd.ebg.aqap.mservice.boot.handler.EBServiceHandlerEnhance;
import kd.ebg.aqap.mservice.impl.CustomizeService;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.entity.base.EBResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;

public class EBServiceHandlerContainer {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(EBServiceHandlerContainer.class);
    private static final String packageScan = "kd.ebg.aqap.bank";
    private static ConcurrentMap<String, EBServiceHandler<? extends EBRequest, ? extends EBResponse>> handlers = new ConcurrentHashMap<String, EBServiceHandler<? extends EBRequest, ? extends EBResponse>>();
    private static ConcurrentMap<String, EBServiceHandlerEnhance> enhanceHandlers = new ConcurrentHashMap<String, EBServiceHandlerEnhance>();
    private static Map<String, JSONObject> handlerInfo = new HashMap<String, JSONObject>(16);
    static final String innerConfigFileName = "handler.json";

    public static synchronized void init() {
        EBServiceHandlerContainer.initInner();
        EBServiceHandlerContainer.initCustomize();
    }

    static Map<String, JSONObject> getHandlerInfo() {
        return handlerInfo;
    }

    private static synchronized void initInner() {
        URL url = Resources.getResource((String)innerConfigFileName);
        try {
            String content = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            EBServiceHandlerContainer.loadFromConfig(content);
        }
        catch (Exception e) {
            logger.info("\u5185\u90e8handler \u914d\u7f6e\u6587\u4ef6\uff1a{} \u52a0\u8f7d\u5931\u8d25", (Object)innerConfigFileName);
            logger.error("\u5177\u4f53\u539f\u56e0\u4e3a", (Throwable)e);
        }
    }

    private static synchronized void initCustomize() {
        try {
            Set implSet = ReflectUtil.getSubTypesOf(EBServiceMethod.class, (String)packageScan);
            for (Class c : implSet) {
                Method method = c.getMethod("register", new Class[0]);
                String content = (String)method.invoke(c.newInstance(), new Object[0]);
                EBServiceHandlerContainer.loadFromCustomize(content);
                CustomizeService.addCustomizeMethodCache(content);
            }
        }
        catch (Exception e) {
            logger.error("\u626b\u63cf\u63d2\u4ef6\u5305\u51fa\u9519\uff1a" + e.getMessage());
        }
    }

    private static void registerOnRemove() {
        EventManager.getInstance().onAlways("handler_remove", params -> {
            JSONObject jsonObject = JSONObject.parseObject((String)params);
            String removeKey = jsonObject.getString("key");
            if (StrUtil.isNotBlank((CharSequence)removeKey) && handlers.containsKey(removeKey)) {
                handlers.remove(removeKey);
                logger.info("\u5378\u8f7d handler : {}", (Object)removeKey);
            }
        });
    }

    private static void registerOnAdd() {
        EventManager.getInstance().onAlways("handler_add", params -> {
            JSONObject jsonObject = JSONObject.parseObject((String)params);
            String addKey = jsonObject.getString("key");
            if (handlerInfo.containsKey(addKey) && !handlers.containsKey(addKey)) {
                JSONObject info = handlerInfo.get(addKey);
                EBServiceHandlerContainer.loadHandler(addKey, info);
                logger.info("\u88c5\u8f7d handler \uff1a{}", (Object)addKey);
            }
        });
    }

    private static void loadFromConfig(String content) {
        JSONObject jsonObject = JSONObject.parseObject((String)content);
        logger.info("\u53d1\u73b0\u4e1a\u52a1\u6846\u67b6\u6807\u8bc6\uff0c\u5171\u8ba1{}\u4e2a", (Object)jsonObject.keySet().size());
        for (String key : jsonObject.keySet()) {
            if (!handlers.containsKey(key)) {
                try {
                    JSONObject handler = jsonObject.getJSONObject(key);
                    EBServiceHandlerContainer.loadHandler(key, handler);
                }
                catch (Throwable e) {
                    logger.error("\u4e1a\u52a1\u6846\u67b6\u6807\u8bc6: {}\u7684\u914d\u7f6e\u52a0\u8f7d\u5931\u8d25", new Object[]{key});
                    logger.error("\u9519\u8bef\u539f\u56e0\u4e3a", e);
                }
                continue;
            }
            logger.info("\u4e1a\u52a1\u6846\u67b6\u6807\u8bc6: {}\u5df2\u7ecf\u52a0\u8f7d", (Object)key);
        }
    }

    private static void loadFromCustomize(String content) {
        JSONObject jsonObject = JSONObject.parseObject((String)content);
        logger.info("\u53d1\u73b0\u5b9a\u5236\u5316\u4e1a\u52a1\u6807\u8bc6\uff0c\u5171\u8ba1{}\u4e2a", (Object)jsonObject.keySet().size());
        for (String key : jsonObject.keySet()) {
            if (!handlers.containsKey(key)) {
                try {
                    JSONObject handler = jsonObject.getJSONObject(key);
                    EBServiceHandlerContainer.loadHandler(key, handler);
                }
                catch (Throwable e) {
                    logger.error("\u5b9a\u5236\u5316\u4e1a\u52a1\u6807\u8bc6: {}\u7684\u914d\u7f6e\u52a0\u8f7d\u5931\u8d25", new Object[]{key});
                    logger.error("\u9519\u8bef\u539f\u56e0\u4e3a", e);
                }
                continue;
            }
            logger.info("\u5b9a\u5236\u5316\u4e1a\u52a1\u6807\u8bc6: {}\u5df2\u7ecf\u52a0\u8f7d", (Object)key);
        }
    }

    private static void loadHandler(String key, JSONObject handler) {
        String methodClassName = handler.getString("methodClass");
        String requestClassName = handler.getString("requestClass");
        String responseClassName = handler.getString("responseClass");
        Class methodClass = ClassUtil.loadClass((String)methodClassName);
        Class requestClass = ClassUtil.loadClass((String)requestClassName);
        Class responseClass = ClassUtil.loadClass((String)responseClassName);
        EBServiceHandler serviceHandler = new EBServiceHandler(key, (EBServiceMethod)ReflectUtil.newInstance((Class)methodClass), requestClass, responseClass);
        EBServiceHandlerEnhance enhance = new EBServiceHandlerEnhance(key, (EBServiceMethod)ReflectUtil.newInstance((Class)methodClass), requestClass, responseClass);
        handlers.put(key, serviceHandler);
        enhanceHandlers.put(key, enhance);
        logger.info("\u4e1a\u52a1\u6846\u67b6\u6807\u8bc6 {} \u52a0\u8f7d\u5b8c\u6bd5 , EBServiceMethod:{} , requestClass:{} , responseClass:{}", new Object[]{key, methodClassName, requestClassName, responseClassName});
        handlerInfo.put(key, handler);
    }

    public static EBServiceHandler<? extends EBRequest, ? extends EBResponse> getHandler(String method) {
        return (EBServiceHandler)handlers.get(method);
    }

    public static EBServiceHandlerEnhance getHandlerEnhance(String method) {
        if (!enhanceHandlers.containsKey(method)) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u65b9\u6cd5:%s\u3002", (String)"EBServiceHandlerContainer_4", (String)"ebg-aqap-mservice", (Object[])new Object[0]), method));
        }
        return (EBServiceHandlerEnhance)enhanceHandlers.get(method);
    }

    public static EBServiceHandlerEnhance getHandlerEnhance(EBRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8bf7\u6c42\u5bf9\u8c61\u4e3a\u7a7a\u503c\u3002", (String)"EBServiceHandlerContainer_1", (String)"ebg-aqap-mservice", (Object[])new Object[0]));
        }
        if (request.getHeader() == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u5bf9\u8c61\u4e3a\u7a7a\u503c\u3002", (String)"EBServiceHandlerContainer_2", (String)"ebg-aqap-mservice", (Object[])new Object[0]));
        }
        String operationName = request.getHeader().getOperationName();
        if (StrUtil.isBlank((CharSequence)operationName)) {
            operationName = request.getHeader().getBizType();
        }
        if (StrUtil.isBlank((CharSequence)operationName)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8c03\u7528\u7684\u65b9\u4f4d\u540d\u4e3a\u7a7a\u3002", (String)"EBServiceHandlerContainer_3", (String)"ebg-aqap-mservice", (Object[])new Object[0]));
        }
        return EBServiceHandlerContainer.getHandlerEnhance(operationName);
    }
}

