/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fjnxs.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fjnxs.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.fjnxs.dc.utils.EBUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest rqst) {
        String accNo = rqst.getAcnt().getAccNo();
        Element message = new Element("Message");
        JDomUtils.addChild((Element)message, (Element)EBUtils.buildPackerHead(this.getBizCode(), Sequence.gen18Sequence()));
        Element body = JDomUtils.addChild((Element)message, (String)"Body");
        Element list = JDomUtils.addChild((Element)body, (String)"List");
        Element map = JDomUtils.addChild((Element)list, (String)"Map");
        String groupAccount = BankBusinessConfig.getGroupAccount(accNo);
        JDomUtils.addChild((Element)map, (String)"AcNo", (String)groupAccount);
        JDomUtils.addChild((Element)map, (String)"QryAcNo", (String)accNo);
        JDomUtils.addChild((Element)map, (String)"Currency", (String)rqst.getBankCurrency());
        return JDomUtils.root2String((Element)message, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = EBUtils.parserResponseInfo(root);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        List list = root.getChild("Body").getChild("List").getChildren("Map");
        Element map = (Element)list.get(0);
        BalanceInfo balanceInfo = new BalanceInfo();
        String currency = JDomUtils.getChildText((Element)map, (String)"Currency");
        balanceInfo.setBankCurrency(currency);
        balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        balanceInfo.setCurrentBalance(new BigDecimal(map.getChildText("Balance")));
        if (!StringUtils.isEmpty((String)map.getChildText("AvailBal"))) {
            balanceInfo.setAvailableBalance(new BigDecimal(map.getChildText("AvailBal")));
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EGroupActBalQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/B2EGroupActBalQry.do?userPassword=" + RequestContextUtils.getBankParameterValue((String)"cif") + "&SIGDATA=1";
        factory.setUri(s);
    }
}

