/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TIMEDEPOSITQUERYTRNRQ {
    public static String pack(BankBalanceRequest rqst) {
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element in = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element timedepositquerytrnrq = JDomUtils.addChild((Element)in, (String)"TIMEDEPOSITQUERYTRNRQ");
        String packageID = RequestContextUtils.getRequestContext().getBankRequestSeq();
        JDomUtils.addChild((Element)timedepositquerytrnrq, (String)"TRNUID", (String)packageID);
        Element rQBODYElement = JDomUtils.addChild((Element)timedepositquerytrnrq, (String)"RQBODY");
        JDomUtils.addChild((Element)rQBODYElement, (String)"ACCTID", (String)rqst.getAcnt().getAccNo());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)cms, (String)encoding);
    }

    public static EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element eb = eb1.getChild("TIMEDEPOSITQUERYTRNRS");
        Element status = eb.getChild("STATUS");
        String iRetCode = status.getChildTextTrim("CODE");
        String msg = status.getChildTextTrim("MESSAGE");
        if (!"0".equalsIgnoreCase(iRetCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%1$s\uff08\u671f\u671b\u503c\uff1a0\uff09\uff0c\u72b6\u6001\u4fe1\u606f\uff1a%2$s\u3002", (String)"TodayBalanceParser_7", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), iRetCode, msg));
        }
        Element rsBody = eb.getChild("RSBODY");
        String timeacctid = rsBody.getChildTextTrim("TIMEACCTID");
        if (!rqst.getAcnt().getAccNo().equalsIgnoreCase(timeacctid)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8d26\u53f7[%1$s]\u4e0e\u8bf7\u6c42\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\u3002", (String)"BalanceImpl_9", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), timeacctid, rqst.getAcnt().getAccNo()));
        }
        String balanceStr = rsBody.getChildTextTrim("BALAMT");
        BigDecimal balance = new BigDecimal(balanceStr);
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(rqst.getAcnt());
        balanceInfo.setCurrentBalance(balance);
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        balanceInfo.setBankCurrency(rqst.getBankCurrency());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }
}

