/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.balancereconciliation;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractQueryBalanceReconciliationImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IQueryBalanceReconciliation;
import kd.ebg.aqap.business.balancereconciliation.bank.BankQueryBalanceReconciliationRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankQueryBalanceReconciliationResponse;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryBalanceReconciliationImpl
extends AbstractQueryBalanceReconciliationImpl
implements IQueryBalanceReconciliation {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryBalanceReconciliationImpl.class);

    public String pack(BankQueryBalanceReconciliationRequest request) {
        BalanceReconciliationDetail detail = request.getDetail();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element in = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element ct = JDomUtils.addChild((Element)in, (String)"BALANCECHECKQUERYTRNRQ");
        String packageID = RequestContextUtils.getRequestContext().getBankRequestSeq();
        JDomUtils.addChild((Element)ct, (String)"TRNUID", (String)packageID);
        Element rqbody = JDomUtils.addChild((Element)ct, (String)"RQBODY");
        this.logger.info("CLT_REF_NO -> {}", (Object)detail.getSys("ref"));
        JDomUtils.addChild((Element)rqbody, (String)"CLT_REF_NO", (String)detail.getSys("ref"));
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)cms, (String)encoding);
    }

    public EBBankQueryBalanceReconciliationResponse parse(BankQueryBalanceReconciliationRequest request, String s) {
        BalanceReconciliationDetail detail = request.getDetail();
        Element root = CIB_DC_Parser.parseString2Root(s);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element eb = eb1.getChild("BALANCECHECKQUERYTRNRS");
        Element status = eb.getChild("STATUS");
        Element rsbody = eb.getChild("RSBODY");
        String reconcile_result = rsbody.getChildText("RECONCILE_RESULT");
        String reconcile_result_msg = rsbody.getChildText("RECONCILE_RESULT_MSG");
        String currency = rsbody.getChildText("RECONCILE_ACCOUNT_CURRENCY");
        String code = status.getChildText("CODE");
        String message = status.getChildText("MESSAGE");
        if (!currency.equalsIgnoreCase(detail.getCurrency())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5bf9\u8d26\u6307\u4ee4\u8fd4\u56de\u7684\u5e01\u79cd\u4e0e\u8bf7\u6c42\u8d26\u6237\u4e0d\u4e00\u81f4\u3002", (String)"QueryBalanceReconciliationImpl_1", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        }
        if (!"0".equalsIgnoreCase(code)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5904\u7406\u51fa\u73b0\u9519\u8bef\uff0c\u9519\u8bef\u4ee3\u7801%1$s,\u9519\u8bef\u4fe1\u606f%2$s\u3002", (String)"QueryBalanceReconciliationImpl_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), code, message));
        }
        if ("0".equalsIgnoreCase(reconcile_result)) {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.SUBMITED, (String)reconcile_result, (String)reconcile_result_msg);
        } else if ("1".equalsIgnoreCase(reconcile_result)) {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.SUCCESS, (String)reconcile_result, (String)reconcile_result_msg);
        } else if ("2".equalsIgnoreCase(reconcile_result)) {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.FAIL, (String)reconcile_result, (String)reconcile_result_msg);
        } else {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.UNKNOWN, (String)reconcile_result, (String)reconcile_result_msg);
        }
        return new EBBankQueryBalanceReconciliationResponse(detail);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BALANCECHECKQUERYTRNRQ";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankQueryBalanceReconciliationRequest request) {
        return true;
    }
}

