/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.detail;

import java.time.LocalDate;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.utils.DateHelper;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailPacker {
    public String packHisDetail(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        return this.packDetail(rqst, pageTag);
    }

    public String packTodayDetail(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        return this.packDetail(rqst, pageTag);
    }

    private String packDetail(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        BankAcnt acnt = rqst.getAcnt();
        LocalDate beginDate = rqst.getStartDate();
        LocalDate endDate = rqst.getEndDate();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element stmt1 = JDomUtils.addChild((Element)msgsv, (String)"SCUSTSTMTTRNRQ");
        JDomUtils.addChild((Element)stmt1, (String)"TRNUID", (String)Sequence.gen18Sequence());
        Element stmt = JDomUtils.addChild((Element)stmt1, (String)"SCUSTSTMTRQ");
        Element acct = JDomUtils.addChild((Element)stmt, (String)"ACCTFROM");
        JDomUtils.addChild((Element)acct, (String)"ACCTID", (String)acnt.getAccNo());
        Element inctran = JDomUtils.addChild((Element)stmt, (String)"INCTRAN");
        LocalDate today = LocalDate.now();
        if (beginDate.isBefore(today)) {
            JDomUtils.addChild((Element)inctran, (String)"DTSTART", (String)this.formatDate(beginDate));
            JDomUtils.addChild((Element)inctran, (String)"DTEND", (String)this.formatDate(endDate));
        } else {
            JDomUtils.addChild((Element)inctran, (String)"DTSTART", (String)this.formatDate(endDate));
            JDomUtils.addChild((Element)inctran, (String)"DTEND", (String)this.formatDate(endDate));
        }
        String pageNo = pageTag.substring(0, pageTag.indexOf("_"));
        JDomUtils.addChild((Element)inctran, (String)"PAGE", (String)pageNo);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)cms, (String)encoding);
    }

    private String formatDate(LocalDate date) {
        return DateHelper.formatDate(date, "yyyy-MM-dd");
    }
}

