/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.allocation;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.services.payment.UseConvertor;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5174\u4e1a\u94f6\u884c\u4e0d\u652f\u6301\u6279\u91cf\u652f\u4ed8", (String)"PayPacker_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        }
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element xpm = JDomUtils.addChild((Element)msgsv, (String)"XPMTTRNRQ");
        JDomUtils.addChild((Element)xpm, (String)"TRNUID", (String)paymentInfos[0].getBankDetailSeqId());
        Element xmptrq = JDomUtils.addChild((Element)xpm, (String)"XMPTRQ");
        Element fundAcct = JDomUtils.addChild((Element)xmptrq, (String)"FUNDACCT");
        if (UseConvertor.isTransUp(paymentInfos[0])) {
            JDomUtils.addChild((Element)fundAcct, (String)"ACCTID", (String)paymentInfos[0].getIncomeAccNo());
        } else {
            JDomUtils.addChild((Element)fundAcct, (String)"ACCTID", (String)paymentInfos[0].getAccNo());
        }
        Element xferInfo = JDomUtils.addChild((Element)xmptrq, (String)"XFERINFO");
        Element acctFrom = JDomUtils.addChild((Element)xferInfo, (String)"ACCTFROM");
        JDomUtils.addChild((Element)acctFrom, (String)"ACCTID", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)acctFrom, (String)"NAME", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)acctFrom, (String)"BANKDESC", (String)paymentInfos[0].getBankName());
        JDomUtils.addChild((Element)acctFrom, (String)"CITY", (String)paymentInfos[0].getAccCity());
        Element acctTo = JDomUtils.addChild((Element)xferInfo, (String)"ACCTTO");
        acctTo.setAttribute("INTERBANK", "Y");
        if (paymentInfos[0].is2SameCity()) {
            acctTo.setAttribute("LOCAL", "Y");
        } else {
            acctTo.setAttribute("LOCAL", "N");
        }
        JDomUtils.addChild((Element)acctTo, (String)"ACCTID", (String)paymentInfos[0].getIncomeAccNo());
        JDomUtils.addChild((Element)acctTo, (String)"NAME", (String)paymentInfos[0].getIncomeAccName());
        JDomUtils.addChild((Element)acctTo, (String)"BANKDESC", (String)paymentInfos[0].getIncomeBankName());
        JDomUtils.addChild((Element)acctTo, (String)"BANKNUM", (String)"");
        JDomUtils.addChild((Element)acctTo, (String)"CITY", (String)paymentInfos[0].getIncomeCity());
        JDomUtils.addChild((Element)xferInfo, (String)"CHEQUENUM", (String)"");
        JDomUtils.addChild((Element)xferInfo, (String)"CURSYM", (String)"RMB");
        JDomUtils.addChild((Element)xferInfo, (String)"TRNAMT", (String)paymentInfos[0].getAmount().setScale(2, 1).toString());
        JDomUtils.addChild((Element)xferInfo, (String)"PMTMODE", (String)"REAL_TIME");
        String exp = paymentInfos[0].getExplanation();
        String kd = "";
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos[0]);
            kd = BizNoUtil.cont((String)paymentInfos[0].getBankDetailSeqId(), (String)exp);
        }
        if (StringUtils.isEmpty((String)kd)) {
            JDomUtils.addChild((Element)xferInfo, (String)"PURPOSE", (String)exp);
        } else {
            JDomUtils.addChild((Element)xferInfo, (String)"PURPOSE", (String)kd);
        }
        JDomUtils.addChild((Element)xferInfo, (String)"MEMO", (String)exp);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)cms, (String)encoding);
    }
}

