/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.income;

import java.util.List;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class PayParser {
    public void parsePay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        List list = eb1.getChildren("GATHERTRNRS");
        block0: for (int i = 0; i < list.size(); ++i) {
            Element xfe;
            Element eb = (Element)list.get(i);
            String packageId = eb.getChildText("TRNUID");
            Element pub = eb.getChild("STATUS");
            String recode = pub.getChildTextTrim("CODE");
            String reMessage = pub.getChildTextTrim("MESSAGE");
            String bankMsg = StringUtils.isEmpty((String)reMessage) ? "" : reMessage;
            String bankCode = recode;
            Element er = eb.getChild("GATHERRS");
            String xferprCode = null;
            String message = "";
            if (null != er && null != (xfe = er.getChild("XFERPRCSTS"))) {
                xferprCode = xfe.getChildText("XFERPRCCODE");
                message = xfe.getChildText("MESSAGE");
            }
            String responseCode = null;
            String responseMsg = message;
            responseCode = !StringUtils.isEmpty((String)recode) && "0".equalsIgnoreCase(recode) ? xferprCode : (!StringUtils.isEmpty((String)recode) && "10514".equalsIgnoreCase(recode) ? "UNKNOWN" : "FAIL");
            if (!StringUtils.isEmpty((String)responseMsg)) {
                bankMsg = responseMsg;
            }
            if (!StringUtils.isEmpty((String)xferprCode)) {
                bankCode = xferprCode;
            }
            for (int j = 0; j < paymentInfos.length; ++j) {
                if (!paymentInfos[j].getBankDetailSeqId().equalsIgnoreCase(packageId)) continue;
                if ("PAYOUT".equalsIgnoreCase(responseCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[j], (PaymentState)PaymentState.SUCCESS, (String)"", (String)bankCode, (String)bankMsg);
                    continue block0;
                }
                if ("UNKNOWN".equalsIgnoreCase(responseCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[j], (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankCode, (String)bankMsg);
                    continue block0;
                }
                if ("FAIL".equalsIgnoreCase(responseCode) || "CANCEL".equalsIgnoreCase(responseCode)) {
                    EBGBusinessUtils.setPaymentFailState((PaymentInfo)paymentInfos[j], (String)"", (String)bankCode, (String)bankMsg);
                    continue block0;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[j], (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankCode, (String)bankMsg);
                continue block0;
            }
        }
    }
}

