/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.individual;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.payment.QueryPay_Public_Impl;
import kd.ebg.aqap.banks.cib.dc.services.payment.company.Pay_Company_Packer;
import kd.ebg.aqap.banks.cib.dc.services.payment.company.Pay_Company_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class IndividualPaymentImpl
extends AbstractPayImpl
implements IPay {
    private static Set<String> getTransUsecn() {
        return Sets.newHashSet((Object[])new String[]{ResManager.loadKDString((String)"\u5de5\u8d44", (String)"IndividualPaymentImpl_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"IndividualPaymentImpl_1", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"IndividualPaymentImpl_2", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u5212", (String)"IndividualPaymentImpl_3", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0])});
    }

    public String getDeveloper() {
        return "zhangyp";
    }

    public String getBizCode() {
        return "XFERTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5174\u4e1a\u94f6\u884c\u5bf9\u79c1\u652f\u4ed8\uff08\u5bf9\u5916\u652f\u4ed8\u3001\u8d39\u7528\u7ba1\u7406\u3001\u5185\u90e8\u8f6c\u8d26\u540c\u4e00\u63a5\u53e3\uff09", (String)"IndividualPaymentImpl_4", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/online/FOX4Securities");
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPay_Public_Impl.class;
    }

    public boolean match(PaymentInfo paymentInfo) {
        boolean flag = this.isSalary(paymentInfo) || Objects.equals("pay", paymentInfo.getSubBizType());
        return flag && !IndividualPaymentImpl.getTransUsecn().contains(paymentInfo.getUseCN()) && paymentInfo.is2Individual();
    }

    public String pack(BankPayRequest request) {
        return new Pay_Company_Packer().packPay(request.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        new Pay_Company_Parser().parsePay(request.getPaymentInfoAsArray(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

