/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.salary;

import java.math.BigDecimal;
import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.utils.DateHelper;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element reptrnrq = JDomUtils.addChild((Element)msgsv, (String)"RPAYOFFTRNRQ");
        JDomUtils.addChild((Element)reptrnrq, (String)"TRNUID", (String)paymentInfos[0].getBankBatchSeqId());
        Element repayoffrq = JDomUtils.addChild((Element)reptrnrq, (String)"RPAYOFFRQ");
        Element rpayoffinfo = JDomUtils.addChild((Element)repayoffrq, (String)"RPAYOFFINFO");
        Element acctfrom = JDomUtils.addChild((Element)rpayoffinfo, (String)"ACCTFROM");
        JDomUtils.addChild((Element)acctfrom, (String)"ACCTID", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)acctfrom, (String)"NAME", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)acctfrom, (String)"BANKDESC", (String)paymentInfos[0].getBankName());
        JDomUtils.addChild((Element)acctfrom, (String)"CITY", (String)paymentInfos[0].getAccCity());
        JDomUtils.addChild((Element)rpayoffinfo, (String)"TITLE", (String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"PayPacker_1", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        JDomUtils.addChild((Element)rpayoffinfo, (String)"DESCRIPTION", (String)"006");
        JDomUtils.addChild((Element)rpayoffinfo, (String)"TOTALCOUNT", (String)(paymentInfos.length + ""));
        JDomUtils.addChild((Element)rpayoffinfo, (String)"TOTALAMOUNT", (String)this.getTotalAmount(paymentInfos));
        JDomUtils.addChild((Element)rpayoffinfo, (String)"CHEQUENUM", (String)paymentInfos[0].getBankBatchSeqId().substring(0, 7));
        JDomUtils.addChild((Element)rpayoffinfo, (String)"DTDUE", (String)DateHelper.formatDate(LocalDate.now(), "yyyy-MM-dd"));
        JDomUtils.addChild((Element)rpayoffinfo, (String)"REMARK", (String)paymentInfos[0].getExplanation());
        Element rpayofflist = JDomUtils.addChild((Element)rpayoffinfo, (String)"RPAYOFFLIST");
        for (PaymentInfo payInfo : paymentInfos) {
            Element rpayoff = JDomUtils.addChild((Element)rpayofflist, (String)"RPAYOFF");
            JDomUtils.addChild((Element)rpayoff, (String)"INDX", (String)payInfo.getBankDetailSeqId());
            JDomUtils.addChild((Element)rpayoff, (String)"ACCTNAME", (String)payInfo.getIncomeAccName());
            JDomUtils.addChild((Element)rpayoff, (String)"ACCTID", (String)payInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)rpayoff, (String)"TRNAMT", (String)payInfo.getAmount().toString());
        }
        return JDomUtils.root2String((Element)cms, (String)RequestContextUtils.getCharset());
    }

    private String getTotalAmount(PaymentInfo[] paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            bigDecimal = bigDecimal.add(info.getAmount());
        }
        return bigDecimal.toString();
    }
}

