/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.opa.service.utils;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.banks.bjb.opa.service.utils.CommonUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CommonPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CommonPacker.class);

    public static JSONObject createData(String serialNo, String tranCode) {
        JSONObject requestJson = new JSONObject();
        requestJson.put("opName", (Object)tranCode);
        requestJson.put("serialNo", (Object)serialNo);
        requestJson.put("reqTime", (Object)LocalDateUtil.formatLocalDateTime((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss"));
        return requestJson;
    }

    public static JSONObject createData(String tranCode) {
        JSONObject requestJson = new JSONObject();
        requestJson.put("opName", (Object)tranCode);
        requestJson.put("serialNo", (Object)Sequence.genSequence());
        requestJson.put("reqTime", (Object)LocalDateUtil.formatLocalDateTime((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss"));
        return requestJson;
    }

    public static String createRequest(String subBizType, String data) {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = CommonPacker.createHead(subBizType, Sequence.genSequence());
        Element dataBody = CommonPacker.createDataBody(data);
        JDomUtils.addChild((Element)simulator, (Element)head);
        JDomUtils.addChild((Element)simulator, (Element)dataBody);
        return JDomUtils.root2String((Element)simulator, (String)EBContext.getContext().getCharsetName());
    }

    private static Element createDataBody(String data) {
        logger.info("\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)data);
        Element body = new Element("body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"data", (String)CommonUtils.encodeBase64Mes(data));
        JDomUtils.addChild((Element)reqPara, (String)"config", (String)CommonUtils.getConfig());
        return body;
    }

    public static Element createHead(String subBizType, String seqNo) {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HH-mm-ss")));
        JDomUtils.addChild((Element)head, (String)"bizType", (String)"business");
        JDomUtils.addChild((Element)head, (String)"subBizType", (String)subBizType);
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqNo);
        return head;
    }
}

