/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccqtgb.dc.services.helper;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccqtgb.dc.services.helper.BankCode;
import kd.ebg.aqap.banks.ccqtgb.dc.services.helper.BaseUtil;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DC_ResponseParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DC_ResponseParser.class);

    public static BankResponse parserCommonHead(String xmlDoc) {
        List childs;
        BankResponse response = new BankResponse();
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)xmlDoc, (String)encoding);
        Element headEle = root.getChild("Head");
        if (headEle == null) {
            headEle = root.getChild("head");
        }
        if ((childs = headEle.getChildren()).size() < 2) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"head\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\u3002", (String)"DC_ResponseParser_0", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]));
        }
        response.setResponseCode(headEle.getChildTextTrim("IBSReturnCode"));
        response.setResponseMessage(headEle.getChildTextTrim("IBSReturnMsg"));
        logger.info("===parserCommonHead\uff1a" + headEle.getChildTextTrim("IBSReturnCode"));
        return response;
    }

    public static List<DetailInfo> parserDeatilsMessage(BankDetailRequest bqst, String rspStr) {
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element bodyEle = root.getChild("Body");
        List resList = bodyEle.getChildren("List");
        Element map = ((Element)resList.get(0)).getChild("Map");
        String returnCode = map.getChildText("ReturnCode");
        String accNo = map.getChildText("AcNo");
        BankAcnt paramBankAcnt = bqst.getAcnt();
        if (!BankCode.SUCCESS_CODE.equalsIgnoreCase(returnCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u7684\u5185\u5c42\u72b6\u6001\u7801\uff1a%s\u3002", (String)"DC_ResponseParser_12", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]), returnCode);
            logger.error(errorMsg);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        if (!paramBankAcnt.getAccNo().equalsIgnoreCase(accNo)) {
            logger.error("\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u8d26\u53f7\u8ddf\u4e0a\u9001\u7684\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0c\u4e0a\u9001\u8d26\u53f7{}\uff0c\u54cd\u5e94\u8d26\u53f7{}", new Object[]{paramBankAcnt.getAccNo(), accNo});
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u8d26\u53f7\u8ddf\u4e0a\u9001\u7684\u8d26\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"DC_ResponseParser_2", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]));
        }
        ArrayList<DetailInfo> infos = new ArrayList<DetailInfo>(16);
        Element list = map.getChild("List");
        if (list == null) {
            return infos;
        }
        List detailList = list.getChildren("Map");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!detailList.isEmpty()) {
            for (Element detail : detailList) {
                String PartnerAcct = detail.getChildText("PartnerAcct");
                String PartnerAcName = detail.getChildText("PartnerAcName");
                String DCFlag = detail.getChildText("DCFlag");
                String Amount = detail.getChildText("Amount");
                String TransDate = detail.getChildText("TransDate");
                String TransTime = detail.getChildText("TransTime");
                String Currency = detail.getChildText("Currency");
                String Balance = detail.getChildText("Balance");
                String Remark = detail.getChildText("Remark");
                String TrsJnlNo = detail.getChildText("TrsJnlNo");
                DetailInfo info = new DetailInfo();
                info.setAccName(paramBankAcnt.getAccName());
                info.setAccNo(paramBankAcnt.getAccNo());
                info.setBankName(paramBankAcnt.getBankName());
                info.setOppAccNo(PartnerAcct);
                info.setOppAccName(PartnerAcName);
                if (StringUtils.isEmpty((String)Amount)) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a", (String)"DC_ResponseParser_3", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]));
                }
                BigDecimal amout = new BigDecimal(Amount.trim());
                if ("D".equalsIgnoreCase(DCFlag)) {
                    info.setDebitAmount(amout);
                    info.setCreditAmount(ParserUtils.ZERO);
                } else if ("C".equalsIgnoreCase(DCFlag)) {
                    info.setDebitAmount(ParserUtils.ZERO);
                    info.setCreditAmount(amout);
                } else {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7DCFlag=%s\u3002", (String)"DC_ResponseParser_13", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]), DCFlag));
                }
                info.setTransDate(LocalDate.parse(TransDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                info.setTransTime(LocalDateTime.parse(TransDate + TransTime, DateTimeFormatter.ofPattern("yyyy-MM-ddHHmmss")));
                info.setCurrency(Currency);
                info.setBalance(BaseUtil.getBigDecimal(Balance));
                info.setBankDetailNo(TrsJnlNo);
                info.setExplanation(Remark);
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(detail);
                info.setJsonMap(jsonStr);
                String transDate = LocalDateUtil.formatDate((LocalDate)info.getTransDate());
                String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                info.setReceiptNo(receiptNo);
                infos.add(info);
            }
        }
        return infos;
    }

    public static void parserPay(PaymentInfo[] paymentInfoArray, String respStr) {
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)respStr, (String)encoding);
        Element bodyEle = root.getChild("Body");
        Element list = bodyEle.getChild("List");
        List maps = list.getChildren("Map");
        for (PaymentInfo paymentInfo : paymentInfoArray) {
            boolean isFindResult = false;
            for (Element map : maps) {
                String PayerAcNo = map.getChildText("PayerAcNo");
                String PayeeAcNo = map.getChildText("PayeeAcNo");
                String PayeeAcName = map.getChildText("PayeeAcName");
                String Amount = map.getChildText("Amount");
                BigDecimal amount = new BigDecimal(Amount);
                if (!paymentInfo.getAccNo().equalsIgnoreCase(PayerAcNo) || !paymentInfo.getIncomeAccNo().equalsIgnoreCase(PayeeAcNo) || !paymentInfo.getIncomeAccName().equalsIgnoreCase(PayeeAcName) || paymentInfo.getAmount().compareTo(amount) != 0) continue;
                isFindResult = true;
                String ReturnCode = map.getChildText("ReturnCode");
                String ReturnMsg = map.getChildText("ReturnMsg");
                if (StringUtils.isNotEmpty((String)ReturnCode)) {
                    if (BankCode.SUCCESS_CODE.equals(ReturnCode)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ReturnCode, (String)ReturnMsg);
                        break;
                    }
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ReturnCode, (String)ReturnMsg);
                    break;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ReturnCode, (String)(StringUtils.isEmpty((String)ReturnMsg) ? ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u7801\u4e3a\u7a7a\u3002", (String)"DC_ResponseParser_5", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]) : ReturnMsg));
                break;
            }
            if (isFindResult) continue;
            logger.info("{}-{}\u672a\u627e\u5230\u76f8\u5173\u8fd4\u56de\u8bb0\u5f55\uff0c\u7f6e\u4e3a\u4ea4\u6613\u672a\u786e\u8ba4", new Object[]{paymentInfo.getAccNo(), String.format("%.2f", paymentInfo.getAmount())});
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8fd4\u56de\u8bb0\u5f55\u3002", (String)"DC_ResponseParser_6", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]));
        }
    }

    public static void parserQueryMessage(PaymentInfo[] paymentInfoArray, String respStr) {
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)respStr, (String)encoding);
        Element headEle = root.getChild("Head");
        String IBSReturnCode = headEle.getChildText("IBSReturnCode");
        String IBSReturnMsg = headEle.getChildText("IBSReturnMsg");
        if (!BankCode.SUCCESS_CODE.equals(IBSReturnCode)) {
            logger.info(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u7684\u5916\u5c42\u72b6\u6001\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s", (String)"QueryBatchPayImpl_1", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]), IBSReturnCode, IBSReturnMsg));
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfoArray, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)IBSReturnCode, (String)IBSReturnMsg);
            return;
        }
        Element bodyEle = root.getChild("Body");
        Element list = bodyEle.getChild("List");
        List maps = list.getChildren("Map");
        PaymentInfo paymentInfo = paymentInfoArray[0];
        for (Element map : maps) {
            String oldJnlNo = map.getChildText("OldJnlNo");
            if (!paymentInfo.getBankBatchSeqID().equals(oldJnlNo)) continue;
            String ReturnCode = map.getChildText("ReturnCode");
            String ReturnMsg = map.getChildText("ReturnMsg");
            if (BankCode.SUCCESS_CODE.equals(ReturnCode)) {
                String tranState = map.getChildText("TranStat");
                if (tranState.equals("0")) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)ReturnCode, (String)ReturnMsg);
                    continue;
                }
                if ("1".equals(tranState)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)ReturnCode, (String)ReturnMsg);
                    continue;
                }
                if ("A".equals(tranState)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ReturnCode, (String)ReturnMsg);
                    continue;
                }
                if ("4".equals(tranState)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)ReturnCode, (String)(StringUtils.isEmpty((String)ReturnMsg) ? ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u62d2\u7edd", (String)"DC_ResponseParser_7", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]) : ReturnMsg));
                    continue;
                }
                if ("11".equals(tranState)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ReturnCode, (String)ReturnMsg);
                    continue;
                }
                if ("2".equals(tranState)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ReturnCode, (String)(StringUtils.isEmpty((String)ReturnMsg) ? ResManager.loadKDString((String)"\u5ba1\u6838\u901a\u8fc7", (String)"DC_ResponseParser_8", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]) : ReturnMsg));
                    continue;
                }
                if ("3".equals(tranState)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)ReturnCode, (String)(StringUtils.isEmpty((String)ReturnMsg) ? ResManager.loadKDString((String)"\u5ba1\u6838\u5df2\u62d2\u7edd", (String)"DC_ResponseParser_9", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]) : ReturnMsg));
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ReturnCode, (String)(StringUtils.isEmpty((String)ReturnMsg) ? String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u5185\u5c42\u4ed8\u6b3e\u72b6\u6001\u7801%s\u3002", (String)"DC_ResponseParser_14", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]), tranState) : ReturnMsg));
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ReturnCode, (String)(StringUtils.isEmpty((String)ReturnMsg) ? String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u72b6\u6001\u7801%s\u3002", (String)"DC_ResponseParser_15", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]), ReturnCode) : ReturnMsg));
        }
    }
}

