/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sfrcb.dc.services.balance;

import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sfrcb.dc.utils.SignUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element BankData = new Element("QLBankData");
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)BankData, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"bsnCode", (String)"CBE002");
        String cstNo = RequestContextUtils.getBankParameterValue((String)"custNo");
        JDomUtils.addChild((Element)opReq, (String)"cstNo", (String)cstNo);
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        Element ReqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)opReq, (Element)ReqParam);
        BankAcnt bankAcnt = bankBalanceRequest.getAcnt();
        JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)bankAcnt.getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"currencyType", (String)bankBalanceRequest.getBankCurrency());
        JDomUtils.addChild((Element)ReqParam, (String)"branchId", (String)"2200");
        String signDataStr = cstNo + "|" + bankAcnt.getAccNo() + "|2200";
        JDomUtils.addChild((Element)ReqParam, (String)"signDataStr", (String)signDataStr);
        String sign = SignUtil.sign(signDataStr);
        JDomUtils.addChild((Element)ReqParam, (String)"signData", (String)sign);
        String requestMsg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)BankData, (String)RequestContextUtils.getCharset());
        return "CBE002|#" + requestMsg;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        try {
            responseStr = URLDecoder.decode(responseStr, RequestContextUtils.getCharset());
            logger.info("url\u89e3\u7801\u540e\u94f6\u884c\u54cd\u5e94\u62a5\u6587:{}", (Object)responseStr);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u7f16\u53f7\u51fa\u9519", (Throwable)e);
        }
        String[] results = responseStr.split("\\|");
        String resultCode = results[0];
        String resultMsg = results[1];
        if (!"0000".equals(resultCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25,\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u7801:%1$s,\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-sfrcb-dc", (Object[])new Object[0]), resultCode, resultMsg));
        }
        String resultXml = responseStr.substring(responseStr.indexOf("#") + 1);
        Element QLBankData = JDomUtils.string2Root((String)resultXml, (String)RequestContextUtils.getCharset());
        Element opRep = JDomUtils.getChildElementNotNull((Element)QLBankData, (String)"opRep");
        Element opResult = JDomUtils.getChildElementNotNull((Element)opRep, (String)"opResult");
        String balance = opResult.getChildTextTrim("balance");
        String balanceAvailable = opResult.getChildTextTrim("balanceAvailable");
        String currencyTyp = opResult.getChildTextTrim("currencyTyp");
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
        balanceInfo.setCurrentBalance(new BigDecimal(balance));
        balanceInfo.setAvailableBalance(new BigDecimal(balanceAvailable));
        balanceInfo.setBankCurrency(currencyTyp);
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CBE002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u8d26\u53f7\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-sfrcb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("content-type", "text/xml; charset=" + RequestContextUtils.getCharset());
    }
}

