/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sfrcb.dc.services.detail;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sfrcb.dc.utils.SignUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);
    private static final Integer PAGE_SIZE = 200;

    public String pack(BankDetailRequest bankDetailRequest) {
        Element BankData = new Element("QLBankData");
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)BankData, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"bsnCode", (String)"CBE006");
        String cstNo = RequestContextUtils.getBankParameterValue((String)"custNo");
        JDomUtils.addChild((Element)opReq, (String)"cstNo", (String)cstNo);
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        Element ReqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)opReq, (Element)ReqParam);
        BankAcnt acnt = bankDetailRequest.getAcnt();
        JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"currencyType", (String)bankDetailRequest.getBankCurrency());
        String startDateStr = bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String endDateStr = bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)ReqParam, (String)"beginDate", (String)startDateStr);
        JDomUtils.addChild((Element)ReqParam, (String)"endDate", (String)endDateStr);
        int pageTag = Integer.parseInt(this.getCurrentPage());
        JDomUtils.addChild((Element)ReqParam, (String)"turnPageBgnPos", (String)(1 + pageTag * PAGE_SIZE + ""));
        JDomUtils.addChild((Element)ReqParam, (String)"turnPageShowQnt", (String)(PAGE_SIZE + ""));
        JDomUtils.addChild((Element)ReqParam, (String)"branchId", (String)"2200");
        String signDataStr = acnt.getAccNo() + "|" + bankDetailRequest.getBankCurrency() + "|" + startDateStr + "|" + endDateStr;
        JDomUtils.addChild((Element)ReqParam, (String)"signDataStr", (String)signDataStr);
        String sign = SignUtil.sign(signDataStr);
        JDomUtils.addChild((Element)ReqParam, (String)"signData", (String)sign);
        String requestMsg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)BankData, (String)RequestContextUtils.getCharset());
        return "CBE006|#" + requestMsg;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String responseStr) {
        this.setLastPage(true);
        try {
            responseStr = URLDecoder.decode(responseStr, RequestContextUtils.getCharset());
            logger.info("url\u89e3\u7801\u540e\u94f6\u884c\u54cd\u5e94\u62a5\u6587:{}", (Object)responseStr);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u7f16\u53f7\u51fa\u9519", (Throwable)e);
        }
        String[] results = responseStr.split("\\|");
        String resultCode = results[0];
        String resultMsg = results[1];
        if (!"0000".equals(resultCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5931\u8d25,\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u7801:%1$s,\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-sfrcb-dc", (Object[])new Object[0]), resultCode, resultMsg));
        }
        String resultXml = responseStr.substring(responseStr.indexOf("#") + 1);
        Element QLBankData = JDomUtils.string2Root((String)resultXml, (String)RequestContextUtils.getCharset());
        Element opRep = JDomUtils.getChildElementNotNull((Element)QLBankData, (String)"opRep");
        Element opResult = JDomUtils.getChildElementNotNull((Element)opRep, (String)"opResult");
        String turnPageTotalQnt = opRep.getChildTextTrim("turnPageTotalQnt");
        if (!StringUtils.isEmpty((String)turnPageTotalQnt)) {
            int currentPage;
            int total = Integer.parseInt(turnPageTotalQnt);
            this.setLastPage(total <= ((currentPage = Integer.parseInt(this.getCurrentPage())) + 1) * PAGE_SIZE);
            this.setCurrentPage(currentPage + 1);
        }
        Element tranList = opResult.getChild("list");
        List list = tranList.getChildren("row");
        BankAcnt acnt = bankDetailRequest.getAcnt();
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        for (int i = 0; i < list.size(); ++i) {
            Element e = (Element)list.get(i);
            DetailInfo detailInfo = new DetailInfo();
            String currencyType = e.getChildTextTrim("currencyType");
            String loanFlag = e.getChildTextTrim("loanFlag");
            String cadDebit = e.getChildTextTrim("cadDebit");
            String cadCredit = e.getChildTextTrim("cadCredit");
            String balance = e.getChildTextTrim("balance");
            String oppositeAccount = e.getChildTextTrim("oppositeAccount");
            String oppositeAccountName = e.getChildTextTrim("oppositeAccountName");
            String transferDate = e.getChildTextTrim("transferDate");
            String hostSeqNb = e.getChildTextTrim("hostSeqNb");
            String comment = e.getChildTextTrim("comment");
            detailInfo.setAccNo(acnt.getAccNo());
            detailInfo.setOppAccNo(oppositeAccount);
            detailInfo.setOppAccName(oppositeAccountName);
            detailInfo.setBalance(new BigDecimal(balance));
            detailInfo.setExplanation(comment);
            LocalDate transDate = LocalDate.parse(transferDate, DateTimeFormatter.BASIC_ISO_DATE);
            detailInfo.setTransDate(transDate);
            detailInfo.setTransTime(transDate.atTime(0, 0, 0));
            if ("D".equalsIgnoreCase(loanFlag)) {
                detailInfo.setDebitAmount(new BigDecimal(cadDebit));
                detailInfo.setCreditAmount(new BigDecimal("0"));
            }
            if ("C".equals(loanFlag)) {
                detailInfo.setDebitAmount(new BigDecimal("0"));
                detailInfo.setCreditAmount(new BigDecimal(cadCredit));
            }
            detailInfo.setCurrency(currencyType);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(e);
            detailInfo.setJsonMap(jsonStr);
            detailInfo.setBankDetailNo(hostSeqNb);
            details.add(detailInfo);
        }
        return new EBBankDetailResponse(details);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CBE006";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u5386\u53f2\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_1", (String)"ebg-aqap-banks-sfrcb-dc", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }
}

