/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.opa.services.balance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import kd.ebg.aqap.banks.zsb.opa.services.utils.SdkInit;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        String yestodayBal;
        String availableBal;
        SdkInit.init();
        HashMap<String, Object> body = new HashMap<String, Object>(1);
        body.put("accNo", request.getAcnt().getAccNo());
        String rspStr = SdkInit.send("yqwfw_qryAccBalance", Sequence.genSequence(), body);
        JSONObject root = JSON.parseObject((String)rspStr);
        String statusCode = root.getString("resultcode");
        String statusDesc = root.getString("resultdesc");
        if (!"000000".equalsIgnoreCase(statusCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)statusCode, (String)statusDesc));
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(request.getAcnt());
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        JSONObject jsonBody = root.getJSONObject("body");
        String bal = jsonBody.getString("bal");
        if (!StringUtils.isEmpty((String)bal)) {
            balanceInfo.setCurrentBalance(new BigDecimal(bal));
        }
        if (!StringUtils.isEmpty((String)(availableBal = jsonBody.getString("availableBal")))) {
            balanceInfo.setAvailableBalance(new BigDecimal(availableBal));
        }
        if (!StringUtils.isEmpty((String)(yestodayBal = jsonBody.getString("yestodayBal")))) {
            balanceInfo.setLastDayAvlBalance(new BigDecimal(yestodayBal));
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

