/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.banks.bocom.dc.service.util.Check;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchBalanceImpl
extends AbstractBalanceImpl
implements ITodayBatchBalance {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BatchBalanceImpl.class);
    static final String transCode = "310101";

    public String pack(BankBalanceRequest bankBalanceRequest) {
        List bankAcntList = bankBalanceRequest.getBankAcntList();
        if (bankAcntList.size() > this.limit()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u901a\u94f6\u884c\u6279\u91cf\u4f59\u989d\u67e5\u8be2\u4e00\u6b21\u67e5\u8be2\u8d26\u53f7\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u3002", (String)"BatchBalanceImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
        }
        Element root = BOCOM_DC_Packer.packRoot(transCode, bankAcntList.size());
        for (BankAcnt bankAcnt : bankAcntList) {
            Element body = JDomUtils.addChild((Element)root, (String)"body");
            String accNo = bankAcnt.getAccNo();
            JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
        }
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(root);
        Check.checkResponseCode(rsp, "0000");
        Element body = root.getChild("body");
        String field_num = ParserUtils.checkUnNullableElement((Element)body, (String)"field_num");
        String record_num = ParserUtils.checkUnNullableElement((Element)body, (String)"record_num");
        String serial_record = ParserUtils.checkUnNullableElement((Element)body, (String)"serial_record");
        this.logger.info("\u8fd4\u56de\u7684\u4f59\u989d\u8bb0\u5f55 serial_record:" + serial_record);
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        String[] splits = serial_record.split("\\|");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        for (int i = 1; i <= recordNum; ++i) {
            BalanceInfo balanceInfo = new BalanceInfo();
            balanceInfos.add(balanceInfo);
            try {
                balanceInfo.setBalanceDateTime(LocalDateTime.now());
                String accNo = splits[fieldNum * i + 1];
                this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), accNo);
                String currency = splits[fieldNum * i + 2];
                String balanceStr = splits[fieldNum * i + 3];
                String availableBalanceStr = splits[fieldNum * i + 4];
                String rspMsg = splits[fieldNum * i + 8];
                String rspCode = splits[fieldNum * i + 9];
                if (!"0".equals(rspCode)) {
                    balanceInfo.setError(rspMsg);
                    continue;
                }
                this.setCurrentBalance(balanceInfo, balanceStr.trim());
                this.setAvailableBalance(balanceInfo, availableBalanceStr.trim());
                this.setBankCurrency(balanceInfo, bankBalanceRequest.getBankCurrency(), currency);
                continue;
            }
            catch (Exception e) {
                this.logger.error("\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                String rspMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5f02\u5e38,%s", (String)"BatchBalanceImpl_2", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), e.getMessage());
                balanceInfo.setError(rspMsg);
            }
        }
        EBBankBalanceResponse balanceResponse = new EBBankBalanceResponse();
        balanceResponse.setBalances(balanceInfos);
        return balanceResponse;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return transCode;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u8d26\u53f7\u4f59\u989d\u67e5\u8be2", (String)"BatchBalanceImpl_1", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public int limit() {
        return 50;
    }

    public boolean match(BankBalanceRequest request) {
        List bankAcntList = request.getBankAcntList();
        for (BankAcnt bankAcnt : bankAcntList) {
            if (!BankBusinessConfig.isFixedAcnt(bankAcnt.getAccNo())) continue;
            return false;
        }
        return true;
    }
}

