/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.payment.allocation;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_PayParser;
import kd.ebg.aqap.banks.bocom.dc.service.payment.allocation.AllocationQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AllocationQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "210202";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212\u4e0b\u62e8,\u652f\u6301\u8de8\u884c\u5212\u62e8,\u53ea\u652f\u6301\u4eba\u6c11\u5e01", (String)"AllocationPayImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return "pay_for_capital_allocation".equalsIgnoreCase(info.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = BOCOM_DC_Packer.packRoot("210202");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        if (ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"AllocationPayImpl_1", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]).equalsIgnoreCase(paymentInfo.getUseCn())) {
            JDomUtils.addChild((Element)body, (String)"pay_flag", (String)"1");
        } else {
            JDomUtils.addChild((Element)body, (String)"pay_flag", (String)"0");
        }
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"rcv_bank_name", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)body, (String)"rcv_acno", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcv_acname", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)"CNY");
        JDomUtils.addChild((Element)body, (String)"amt", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfo.getBankBatchSeqId());
        boolean needSubSummary = BankBusinessConfig.isNeedSubSummary();
        String exp = paymentInfos[0].getExplanation();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos[0]);
            exp = BizNoUtil.cont((String)paymentInfos[0].getBankDetailSeqId(), (String)exp);
        }
        JDomUtils.addChild((Element)body, (String)"summary", (String)PaymentUtil.substringChinese((boolean)needSubSummary, (String)exp, (int)60, (String)RequestContextUtils.getCharset()));
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        BOCOM_DC_PayParser.parsePay(request.getPaymentInfoAsArray(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

