/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.payment.company;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_PayParser;
import kd.ebg.aqap.banks.bocom.dc.service.payment.company.AuthorizedQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AuthorizedPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AuthorizedQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "210205";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u5916\u8f6c\u8d26\u5f55\u5165\u3001\u7f51\u94f6\u6388\u6743\u4ea4\u6613\uff08210205\uff09(\u76ee\u524d\u4ec5\u652f\u6301\u4eba\u6c11\u5e01)", (String)"AuthorizedPayImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return false;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = BOCOM_DC_Packer.packRoot("210205");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"rcv_bank_name", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)body, (String)"rcv_acno", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcv_acname", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"amt", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfo.getBankBatchSeqId());
        boolean needSubSummary = BankBusinessConfig.isNeedSubSummary();
        String exp = paymentInfos[0].getExplanation();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos[0]);
            exp = BizNoUtil.cont((String)paymentInfos[0].getBankDetailSeqId(), (String)exp);
        }
        JDomUtils.addChild((Element)body, (String)"summary", (String)PaymentUtil.substringChinese((boolean)needSubSummary, (String)exp, (int)60, (String)RequestContextUtils.getCharset()));
        if (paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)body, (String)"bank_flag", (String)"0");
        } else {
            JDomUtils.addChild((Element)body, (String)"bank_flag", (String)"1");
        }
        if (paymentInfo.is2SameCity()) {
            JDomUtils.addChild((Element)body, (String)"area_flag", (String)"0");
        } else {
            JDomUtils.addChild((Element)body, (String)"area_flag", (String)"1");
        }
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        BOCOM_DC_PayParser.parsePay(request.getPaymentInfoAsArray(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

