/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.opa.services.utils;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.spec.SM2ParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class GmUtil {
    private static X9ECParameters x9ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
    private static ECDomainParameters ecDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
    private static ECParameterSpec ecParameterSpec = new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
    private static final int RS_LEN = 32;

    public static byte[] signSm3WithSm2(byte[] msg, byte[] userId, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchProviderException, SignatureException {
        return GmUtil.rsAsn1ToPlainByteArray(GmUtil.signSm3WithSm2Asn1Rs(msg, userId, privateKey));
    }

    public static byte[] signSm3WithSm2Asn1Rs(byte[] msg, byte[] userId, PrivateKey privateKey) throws InvalidAlgorithmParameterException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        SM2ParameterSpec parameterSpec = new SM2ParameterSpec(userId);
        Signature signer = Signature.getInstance("SM3withSM2", "BC");
        signer.setParameter((AlgorithmParameterSpec)parameterSpec);
        signer.initSign(privateKey, new SecureRandom());
        signer.update(msg, 0, msg.length);
        return signer.sign();
    }

    public static boolean verifySm3WithSm2(byte[] msg, byte[] userId, byte[] rs, PublicKey publicKey) {
        if (rs == null || msg == null || userId == null) {
            return false;
        }
        if (rs.length != 64) {
            return false;
        }
        return GmUtil.verifySm3WithSm2Asn1Rs(msg, userId, GmUtil.rsPlainByteArrayToAsn1(rs), publicKey);
    }

    public static boolean verifySm3WithSm2Asn1Rs(byte[] msg, byte[] userId, byte[] rs, PublicKey publicKey) {
        try {
            SM2ParameterSpec parameterSpec = new SM2ParameterSpec(userId);
            Signature verifier = Signature.getInstance("SM3withSM2", "BC");
            verifier.setParameter((AlgorithmParameterSpec)parameterSpec);
            verifier.initVerify(publicKey);
            verifier.update(msg, 0, msg.length);
            return verifier.verify(rs);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static byte[] sm2Decrypt(byte[] data, PrivateKey key) {
        try {
            BCECPrivateKey localECPrivateKey = (BCECPrivateKey)key;
            ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(localECPrivateKey.getD(), ecDomainParameters);
            SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
            sm2Engine.init(false, (CipherParameters)ecPrivateKeyParameters);
            try {
                return sm2Engine.processBlock(data, 0, data.length);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sm2Encrypt(byte[] data, PublicKey key) {
        BCECPublicKey localECPublicKey = (BCECPublicKey)key;
        ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(localECPublicKey.getQ(), ecDomainParameters);
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)ecPublicKeyParameters, new SecureRandom()));
        try {
            return sm2Engine.processBlock(data, 0, data.length);
        }
        catch (InvalidCipherTextException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sm3(byte[] bytes) {
        SM3Digest sm3 = new SM3Digest();
        sm3.update(bytes, 0, bytes.length);
        byte[] result = new byte[sm3.getDigestSize()];
        sm3.doFinal(result, 0);
        return result;
    }

    public static byte[] sm4Encrypt(byte[] keyBytes, byte[] plain, String algo) {
        if (keyBytes.length != 16) {
            throw new RuntimeException("err key length");
        }
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
            Cipher out = Cipher.getInstance(algo, "BC");
            out.init(1, key);
            return out.doFinal(plain);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sm4Decrypt(byte[] keyBytes, byte[] cipher, String algo) {
        if (keyBytes.length != 16) {
            throw new RuntimeException("err key length");
        }
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
            Cipher in = Cipher.getInstance(algo, "BC");
            in.init(2, key);
            return in.doFinal(cipher);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static byte[] generateSM4Key() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("SM4");
            kg.init(new SecureRandom());
            SecretKey key = kg.generateKey();
            return key.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private static byte[] bigIntToFixexLengthBytes(BigInteger rOrS) {
        byte[] rs = rOrS.toByteArray();
        if (rs.length == 32) {
            return rs;
        }
        if (rs.length == 33 && rs[0] == 0) {
            return Arrays.copyOfRange((byte[])rs, (int)1, (int)33);
        }
        if (rs.length < 32) {
            byte[] result = new byte[32];
            Arrays.fill((byte[])result, (byte)0);
            System.arraycopy(rs, 0, result, 32 - rs.length, rs.length);
            return result;
        }
        throw new RuntimeException("err rs: " + Hex.toHexString((byte[])rs));
    }

    private static byte[] rsAsn1ToPlainByteArray(byte[] rsDer) {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)rsDer);
        byte[] r = GmUtil.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue());
        byte[] s = GmUtil.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        byte[] result = new byte[64];
        System.arraycopy(r, 0, result, 0, r.length);
        System.arraycopy(s, 0, result, 32, s.length);
        return result;
    }

    private static byte[] rsPlainByteArrayToAsn1(byte[] sign) {
        if (sign.length != 64) {
            throw new RuntimeException("err rs. ");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)0, (int)32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)32, (int)64));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        try {
            return new DERSequence(v).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator kpGen = KeyPairGenerator.getInstance("EC", "BC");
            kpGen.initialize((AlgorithmParameterSpec)ecParameterSpec, new SecureRandom());
            KeyPair kp = kpGen.generateKeyPair();
            return kp;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BCECPrivateKey getPrivatekeyFromD(BigInteger d) {
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(d, ecParameterSpec);
        return new BCECPrivateKey("EC", ecPrivateKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static BCECPublicKey getPublickeyFromXY(BigInteger x, BigInteger y) {
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(x9ECParameters.getCurve().createPoint(x, y), ecParameterSpec);
        return new BCECPublicKey("EC", ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            Security.removeProvider("BC");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

