/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbb.opa.services;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import kd.bos.id.ID;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.model.bank.BankSerialNo;
import kd.ebg.egf.common.repository.BankSerialNoRepository;

public class NBB_OPA_Batch_SeqID_Creator
implements IBankBatchSeqIDCreator {
    public String getBankBatchSeqID() {
        return NBB_OPA_Batch_SeqID_Creator.genNum8Sequence();
    }

    public static synchronized String genNum8Sequence() {
        String sequence;
        boolean exsist;
        String today = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        BankSerialNoRepository bankSerialNoRepository = (BankSerialNoRepository)SpringContextUtil.getBean(BankSerialNoRepository.class);
        EBContext context = EBContext.getContext();
        do {
            long id = ID.genLongId() + 200000000000000000L;
            sequence = String.valueOf(id);
            id = Long.parseLong(sequence.substring(0, 16));
            id ^= id >>> 32;
            sequence = today + String.valueOf(id).substring(8);
            exsist = bankSerialNoRepository.isExsist(sequence, context.getCustomID(), context.getBankVersionID());
            if (exsist) continue;
            BankSerialNo bankSerialNo = new BankSerialNo();
            bankSerialNo.setBankVersionId(context.getBankVersionID());
            bankSerialNo.setCustomId(context.getCustomID());
            bankSerialNo.setNumber(id + "");
            try {
                bankSerialNoRepository.save(bankSerialNo);
            }
            catch (Exception var8) {
                exsist = true;
            }
        } while (exsist);
        return sequence;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

