/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbb.opa.services.payment.batch;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nbb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.nbb.opa.services.payment.batch.QryBatchPayImpl;
import kd.ebg.aqap.banks.nbb.opa.services.utils.NBBUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BatchPaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BatchPaymentImpl.class);

    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryBatchPayImpl.class;
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        String ret;
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        try {
            NBBUtil.initSdk(request.getHeader().getCustomerID());
            String custId = RequestContextUtils.getBankParameterValue((String)"custId");
            String corpCode = BankBusinessConfig.getCode(request.getAcnt().getAccNo());
            if (StringUtils.isEmpty((String)corpCode)) {
                corpCode = RequestContextUtils.getBankParameterValue((String)"corpCode");
            }
            JSONObject reqStr = new JSONObject();
            JSONObject data = new JSONObject();
            data.put("custId", (Object)custId);
            data.put("batchSerialNo", (Object)paymentInfo.getBankBatchSeqId());
            JSONArray infoA = new JSONArray();
            if ("pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType())) {
                data.put("businessCode", (Object)"nis_smart_wage");
                data.put("showFlag", (Object)"0");
                for (PaymentInfo info : paymentInfos) {
                    JSONObject dtls = new JSONObject();
                    dtls.put("dtlSerialNo", (Object)info.getBankDetailSeqID());
                    dtls.put("payAcc", (Object)info.getAccNo());
                    dtls.put("rcvAcc", (Object)info.getIncomeAccNo());
                    dtls.put("corpCode", (Object)corpCode);
                    dtls.put("rcvBank", (Object)info.getIncomeBankName());
                    dtls.put("rcvName", (Object)info.getIncomeAccName());
                    dtls.put("amt", (Object)info.getAmount());
                    infoA.add((Object)dtls);
                }
            } else {
                data.put("businessCode", (Object)"nis_batch_transfer");
                for (PaymentInfo info : paymentInfos) {
                    JSONObject dtls = new JSONObject();
                    dtls.put("dtlSerialNo", (Object)info.getBankDetailSeqID());
                    dtls.put("payAcc", (Object)info.getAccNo());
                    dtls.put("rcvAcc", (Object)info.getIncomeAccNo());
                    dtls.put("corpCode", (Object)corpCode);
                    dtls.put("rcvBank", (Object)info.getIncomeBankName());
                    dtls.put("rcvName", (Object)info.getIncomeAccName());
                    dtls.put("amt", (Object)info.getAmount());
                    dtls.put("purpose", (Object)(StringUtils.isEmpty((String)info.getExplanation()) ? ResManager.loadKDString((String)"\u6279\u91cf\u8f6c\u8d26", (String)"BatchPaymentImpl_0", (String)"ebg-aqap-banks-nbb-opa", (Object[])new Object[0]) : info.getExplanation()));
                    infoA.add((Object)dtls);
                }
            }
            data.put("totalAmt", (Object)NBBUtil.getTotalAmt(paymentInfos));
            data.put("totalNumber", (Object)paymentInfos.size());
            data.put("transferDtls", (Object)infoA);
            reqStr.put("Data", (Object)data);
            ret = NBBUtil.send("batchTransfer", "batchTransfer", reqStr.toJSONString(), this.getBizDesc());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        JSONObject retJson = JSONObject.parseObject((String)ret);
        JSONObject retData = retJson.getJSONObject("Data");
        String code = retData.getString("retCode");
        String msg = retData.getString("retMsg");
        if ("0000".equalsIgnoreCase(code)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)msg, (String)"", (String)"");
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)code, (String)msg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "batchTransfer/batchTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u652f\u4ed8", (String)"BatchPaymentImpl_2", (String)"ebg-aqap-banks-nbb-opa", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType()) || "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.getTotalCount() > 1;
    }
}

