/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbb.opa.services.payment.oversea;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nbb.opa.services.utils.NBBUtil;
import kd.ebg.aqap.business.file.AbstractAttachmentImpl;
import kd.ebg.aqap.business.payment.bank.BankAttachmentRequest;
import kd.ebg.aqap.business.payment.bank.BankAttachmentResponse;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.aqap.common.model.PayAttachment;
import kd.ebg.egf.common.exception.EBPayUnknownException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.io.FileUtils;

public class AttachmentUploadImpl
extends AbstractAttachmentImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(AttachmentUploadImpl.class);

    public String pack(PayAttachment payAttachment) {
        return null;
    }

    public void parse(PayAttachment payAttachment, String s) {
    }

    public BankAttachmentResponse doBiz(BankAttachmentRequest bankAttachmentRequest) {
        List attachments = bankAttachmentRequest.getPayAttachments();
        if (CollectionUtil.isEmpty((Collection)attachments)) {
            return new BankAttachmentResponse(attachments);
        }
        super.prepareAttachment(attachments);
        attachments.forEach(payAttachment -> {
            String overseaAttachmentPath = super.getOverseaAttachmentPath(payAttachment.getBankVersionID());
            String fileName = payAttachment.getFileName();
            File aFile = FileUtils.getFile((String[])new String[]{overseaAttachmentPath + File.separator + fileName});
            try {
                String ret = NBBUtil.sendFile("tmsForex", "easyRemitSubmit", aFile, this.getBizDesc());
                JSONObject retJson = JSONObject.parseObject((String)ret);
                JSONObject retData = retJson.getJSONObject("Data");
                String code = retData.getString("retCode");
                String data = retData.getString("data");
                if ("0000".equalsIgnoreCase(code)) {
                    logger.info("\u4e0a\u4f20\u9644\u4ef6\u6210\u529f\u3002");
                    payAttachment.setBankRefID(data);
                    this.setUploadStatus(attachments, AttachmentState.SUCCESS, "", code);
                } else {
                    logger.info("\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25\u3002");
                    this.setUploadStatus((PayAttachment)payAttachment, AttachmentState.FAIL, "", code);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                String message = e.getMessage();
                if (StringUtils.isNotEmpty((String)message) && message.length() > 255) {
                    message = message.substring(0, 255);
                }
                if (e instanceof EBPayUnknownException) {
                    this.setUploadStatus((PayAttachment)payAttachment, AttachmentState.UNKNOWN, "", message);
                }
                this.setUploadStatus((PayAttachment)payAttachment, AttachmentState.FAIL, "", message);
            }
        });
        return new BankAttachmentResponse(attachments);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "AttachmentUpload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6", (String)"", (String)"ebg-aqap-banks-nbb-opa", (Object[])new Object[0]);
    }
}

