/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbb.opa.services.utils;

import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.banks.nbb.opa.services.payment.oversea.AttachmentUploadImpl;
import kd.ebg.aqap.banks.nbb.opa.services.utils.UploadResponse;
import kd.ebg.aqap.business.payment.bank.BankAttachmentRequest;
import kd.ebg.aqap.business.payment.bank.BankAttachmentResponse;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.aqap.common.framework.services.PayAttachmentService;
import kd.ebg.aqap.common.model.PayAttachment;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class UploadUtil {
    private PayAttachmentService payAttachmentService = (PayAttachmentService)SpringContextUtil.getBean(PayAttachmentService.class);

    public static UploadUtil getInstance() {
        return new UploadUtil();
    }

    public UploadResponse uploadAttachment(PaymentInfo paymentInfo) {
        List payAttachments = this.payAttachmentService.findByBankBatchSeqId(paymentInfo.getBankBatchSeqID());
        if (payAttachments.isEmpty()) {
            return UploadResponse.notExist();
        }
        PayAttachment payAttachment = (PayAttachment)payAttachments.get(0);
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(payAttachment.getCustomID()).logRequestSeqID(paymentInfo.getBankBatchSeqID()).bizName("attachmentUpload").subBizName("attachmentUpload").bankVersionID(payAttachment.getBankVersionID()).bankLoginID(payAttachment.getBankLoginID()).logBizSeqID(paymentInfo.getBankBatchSeqID()).bizSeqID(Sequence.genSequence()).requestSeqID(Sequence.genSequence()).loggerBatchNo(paymentInfo.getBankBatchSeqID()).loggerDetailNo(Sequence.genSequence()).loggerBankNo(Sequence.genSequence()).build();
        BankAcnt bankAcnt = new BankAcnt();
        context.setBankAcnt(bankAcnt);
        EBContext.setContext((EBContext)context);
        BankAttachmentRequest bankAttachmentRequest = new BankAttachmentRequest();
        bankAttachmentRequest.setPayAttachments(payAttachments);
        BankAttachmentResponse bankAttachmentResponse = new AttachmentUploadImpl().doBiz(bankAttachmentRequest);
        ArrayList<String> fileUploadCodes = new ArrayList<String>(2);
        List attachments = bankAttachmentResponse.getPayAttachments();
        for (PayAttachment attachment : attachments) {
            if (attachment.getStatus().intValue() != AttachmentState.SUCCESS.getId()) continue;
            fileUploadCodes.add(attachment.getBankRefID());
        }
        return fileUploadCodes.size() != attachments.size() ? UploadResponse.fail() : UploadResponse.success(fileUploadCodes);
    }
}

