/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.curandfixed.cur2fixed;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.banks.icbc.cmp.service.curandfixed.PriCafUtil;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.ICurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.framework.utils.PackerUtils;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CurAndFixedImpl
extends AbstractCAFImpl
implements ICurAndFixed {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CurAndFixedImpl.class);

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(this.getBizCode(), ((CurAndFixedInfo)cafInfos.get(0)).getBatchSeqId());
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"TotalNum", (String)"1");
        BigDecimal amount = new BigDecimal(curAndFixedInfo.getAmount());
        String bankAmount = PackerUtils.convertYuan2CentStr((BigDecimal)amount);
        JDomUtils.addChild((Element)in, (String)"TotalAmt", (String)bankAmount);
        String signDate4Test = RequestContextUtils.getBankParameterValue((String)"signDate4Test");
        if (StringUtils.isEmpty((String)signDate4Test)) {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")));
        } else {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmssSSS"))));
        }
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        Element rd = JDomUtils.addChild((Element)in, (String)"rd");
        JDomUtils.addChild((Element)rd, (String)"iSeqno", (String)curAndFixedInfo.getDetailSeqId());
        JDomUtils.addChild((Element)rd, (String)"StartDate", (String)"");
        JDomUtils.addChild((Element)rd, (String)"StartTime", (String)"");
        JDomUtils.addChild((Element)rd, (String)"PayAccNo", (String)curAndFixedInfo.getAccNo());
        JDomUtils.addChild((Element)rd, (String)"PayAccNameCN", (String)curAndFixedInfo.getAccName());
        JDomUtils.addChild((Element)rd, (String)"PayAccNameEN", (String)"");
        JDomUtils.addChild((Element)rd, (String)"PayBankName", (String)"");
        JDomUtils.addChild((Element)rd, (String)"FixAccNo", (String)curAndFixedInfo.getFixedAccNo());
        JDomUtils.addChild((Element)rd, (String)"FixAccNameCN", (String)curAndFixedInfo.getFixedAccName());
        JDomUtils.addChild((Element)rd, (String)"FixAccNameEN", (String)"");
        JDomUtils.addChild((Element)rd, (String)"FixBankName", (String)"");
        JDomUtils.addChild((Element)rd, (String)"CurrType", (String)curAndFixedInfo.getCurrency());
        JDomUtils.addChild((Element)rd, (String)"PayAmt", (String)bankAmount);
        String depositTermValue = curAndFixedInfo.getDepositTermValue();
        if (PriCafUtil.checkTermVal(depositTermValue)) {
            throw EBExceiptionUtil.serviceException((String)PriCafUtil.getBankMsg(ResManager.loadKDString((String)"\u5b58\u671f\u6709\u8bef\uff0c\u5b58\u91cf\u5ba2\u6237\u5bf9\u4e8e\u4eba\u6c11\u5e01\u548c\u5916\u5e01\u53ea\u80fd\u662f3\uff0c6\uff0c12\uff01", (String)"CurAndFixedImpl_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0])));
        }
        JDomUtils.addChild((Element)rd, (String)"FixDays", (String)depositTermValue);
        JDomUtils.addChild((Element)rd, (String)"Remark", (String)PriCafUtil.getRemark(curAndFixedInfo.getExplanation()));
        JDomUtils.addChild((Element)rd, (String)"CashBill", (String)"0");
        String flag = curAndFixedInfo.getNextDepositType();
        if (!"0".equals(flag)) {
            flag = "1";
        }
        JDomUtils.addChild((Element)rd, (String)"AutoFlag", (String)flag);
        JDomUtils.addChild((Element)rd, (String)"UseCode", (String)"");
        JDomUtils.addChild((Element)rd, (String)"UseCN", (String)"");
        JDomUtils.addChild((Element)rd, (String)"EnSummary", (String)"");
        JDomUtils.addChild((Element)rd, (String)"PostScript", (String)"");
        JDomUtils.addChild((Element)rd, (String)"Summary", (String)"");
        JDomUtils.addChild((Element)rd, (String)"Ref", (String)"");
        JDomUtils.addChild((Element)rd, (String)"Oref", (String)"");
        JDomUtils.addChild((Element)rd, (String)"ERPSqn", (String)"");
        JDomUtils.addChild((Element)rd, (String)"BusCode", (String)"");
        JDomUtils.addChild((Element)rd, (String)"ERPcheckno", (String)"");
        JDomUtils.addChild((Element)rd, (String)"CrvouhType", (String)"");
        JDomUtils.addChild((Element)rd, (String)"CrvouhName", (String)"");
        JDomUtils.addChild((Element)rd, (String)"CrvouhNo", (String)"");
        JDomUtils.addChild((Element)rd, (String)"ReqReserved3", (String)"");
        JDomUtils.addChild((Element)rd, (String)"ReqReserved4", (String)"");
        String encoding = "GBK";
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        logger.info("\u5f53\u524d\u5b9a\u8f6c\u6d3b\u62a5\u6587\u5b57\u7b26\u96c6\u4e3a" + encoding);
        logger.info("\u5f85\u7b7e\u540d\u62a5\u6587\u4e3a" + reqstMsg);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg);
        return ICBC_CMP_Packer.createMessageWithHeadForPay(msgSigned, this.getBizCode(), "0.0.0.1", 0, ((CurAndFixedInfo)cafInfos.get(0)).getBatchSeqId());
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(s, true);
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        Element out = eb.getChild("out");
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode()) || out == null) {
            CAFUtil.setState((List)cafInfos, (CurAndFixedState)CurAndFixedState.UNKNOWN, (String)"", (String)headRsp.getResponseCode(), (String)headRsp.getResponseCode());
            ebBankCurAndFixedResponse.setDetails(cafInfos);
            return ebBankCurAndFixedResponse;
        }
        List rds = out.getChildren("rd");
        for (int i = 0; i < rds.size(); ++i) {
            Element rd = (Element)rds.get(i);
            String iRetCode = rd.getChildText("iRetCode");
            String iRetMsg = rd.getChildText("iRetMsg");
            String result = rd.getChildText("Result");
            String rate = rd.getChildTextTrim("Rate");
            if (StringUtils.isNotEmpty((String)rate)) {
                BigDecimal rateBig = new BigDecimal(rate);
                BigDecimal divide = rateBig.divide(new BigDecimal("1000000"), 5, 1);
                curAndFixedInfo.setRate(divide.toString());
            }
            if ("7".equalsIgnoreCase(result)) {
                CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.SUBMITED, (String)"", (String)iRetCode, (String)iRetMsg);
                continue;
            }
            if ("6".equalsIgnoreCase(result) || "8".equalsIgnoreCase(result)) {
                CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.FAIL, (String)"", (String)iRetCode, (String)iRetMsg);
                continue;
            }
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.UNKNOWN, (String)"", (String)iRetCode, (String)iRetMsg);
        }
        ebBankCurAndFixedResponse.setDetails(cafInfos);
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "DQCKKL";
    }

    public String getBizDesc() {
        return null;
    }
}

