/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.payment.company;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_PayParser;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.icbc.cmp.service.utils.CommonUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.framework.utils.PackerUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        int batchNum = BankBusinessConfig.getPayentBatchNum();
        if (batchNum < 1) {
            return 150;
        }
        return batchNum;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "PAYENT";
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u516c\u5171\u652f\u4ed8\uff0c\u4e0a\u5212\u4e0b\u62e8\uff0c\u9010\u7b14\u5165\u8d26\uff1b\u63d0\u4ea4\u300a\u652f\u4ed8\u6307\u4ee4.xls\u300b\u548c\u67e5\u8be2\u300a\u652f\u4ed8\u6307\u4ee4.xls\u300b\uff1b\u4ea4\u6613\u7801\u4e3aPAYENT\u548cQPAYENT\u3002", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && !BankBusinessConfig.isUseZipInterface() && paymentInfo.getIndividual() == false || "pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType()) && !BankBusinessConfig.isLoanAccountPool(paymentInfo.getAccNo(), paymentInfo.getIncomeAccNo());
    }

    public String pack(BankPayRequest request) {
        BigDecimal totalAmt = new BigDecimal("0.00");
        List paymentInfos = request.getPaymentInfos();
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(this.getBizCode(), ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"OnlBatF", (String)"1");
        if (((PaymentInfo)paymentInfos.get(0)).getMerge().booleanValue()) {
            JDomUtils.addChild((Element)in, (String)"SettleMode", (String)"2");
        } else {
            JDomUtils.addChild((Element)in, (String)"SettleMode", (String)"0");
        }
        JDomUtils.addChild((Element)in, (String)"TotalNum", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)in, (String)"TotalAmt", (String)request.getTotalAmount().toString());
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        String signDate4Test = parameter.getBankParameter("signDate4Test");
        boolean isProduct = StrUtil.isEmpty((String)signDate4Test);
        if (isProduct) {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")));
        } else {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmssSSS"))));
        }
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            PaymentInfo info = (PaymentInfo)paymentInfos.get(i);
            totalAmt = totalAmt.add(info.getAmount());
            Element rd = JDomUtils.addChild((Element)in, (String)"rd");
            JDomUtils.addChild((Element)rd, (String)"iSeqno", (String)info.getBankSerialNo());
            JDomUtils.addChild((Element)rd, (String)"ReimburseNo", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ReimburseNum", (String)"");
            if (isProduct && null != info.getBookingTime() && info.getBookingTime().toLocalDate().isAfter(LocalDate.now())) {
                JDomUtils.addChild((Element)rd, (String)"StartDate", (String)info.getBookingTime().format(DateTimeFormatter.BASIC_ISO_DATE));
                PaymentUtil.setBookPayFlag((PaymentInfo)info);
            } else {
                JDomUtils.addChild((Element)rd, (String)"StartDate", (String)"");
            }
            JDomUtils.addChild((Element)rd, (String)"StartTime", (String)"");
            JDomUtils.addChild((Element)rd, (String)"PayType", (String)(info.getUrgent() != false ? "1" : "2"));
            JDomUtils.addChild((Element)rd, (String)"PayAccNo", (String)info.getAccNo());
            JDomUtils.addChild((Element)rd, (String)"PayAccNameCN", (String)info.getAccName());
            JDomUtils.addChild((Element)rd, (String)"PayAccNameEN", (String)"");
            JDomUtils.addChild((Element)rd, (String)"RecAccNo", (String)info.getIncomeAccNo());
            JDomUtils.addChild((Element)rd, (String)"RecAccNameCN", (String)info.getIncomeAccName());
            JDomUtils.addChild((Element)rd, (String)"RecAccNameEN", (String)"");
            if (!info.getSameBank().booleanValue()) {
                JDomUtils.addChild((Element)rd, (String)"SysIOFlg", (String)"2");
            } else if (CommonUtils.isInner2Outer(info.getIncomeAccNo())) {
                JDomUtils.addChild((Element)rd, (String)"SysIOFlg", (String)"2");
            } else {
                JDomUtils.addChild((Element)rd, (String)"SysIOFlg", (String)"1");
            }
            JDomUtils.addChild((Element)rd, (String)"IsSameCity", (String)"");
            JDomUtils.addChild((Element)rd, (String)"Prop", (String)(info.getIndividual() != false ? "1" : "0"));
            JDomUtils.addChild((Element)rd, (String)"RecICBCCode", (String)"");
            JDomUtils.addChild((Element)rd, (String)"RecCityName", (String)CommonUtils.substringChinese(StrUtil.trim((CharSequence)info.getIncomeBankAddress()), 40));
            JDomUtils.addChild((Element)rd, (String)"RecBankNo", (String)info.getIncomeCnaps());
            JDomUtils.addChild((Element)rd, (String)"RecBankName", (String)info.getIncomeBankName());
            JDomUtils.addChild((Element)rd, (String)"CurrType", (String)info.getCurrency());
            JDomUtils.addChild((Element)rd, (String)"PayAmt", (String)PackerUtils.convertYuan2CentStr((BigDecimal)info.getAmount()));
            JDomUtils.addChild((Element)rd, (String)"UseCode", (String)"");
            String exp = info.getExplanation();
            if (exp != null && exp.length() > 10) {
                exp = exp.substring(0, 10);
            }
            JDomUtils.addChild((Element)rd, (String)"UseCN", (String)exp);
            JDomUtils.addChild((Element)rd, (String)"EnSummary", (String)"");
            if (CommonUtils.purposeOrSummary("3")) {
                JDomUtils.addChild((Element)rd, (String)"PostScript", (String)"");
            } else if (BankBusinessConfig.isPostScriptIntercept()) {
                String PostScript = "";
                PostScript = !((PaymentInfo)paymentInfos.get(i)).is2SameBank() ? CommonUtils.substringChinese(StringUtils.trim((String)((PaymentInfo)paymentInfos.get(i)).getExplanation()), 60) : CommonUtils.substringChinese(StringUtils.trim((String)((PaymentInfo)paymentInfos.get(i)).getExplanation()), 100);
                JDomUtils.addChild((Element)rd, (String)"PostScript", (String)PostScript);
            } else {
                JDomUtils.addChild((Element)rd, (String)"PostScript", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation());
            }
            String Summary = info.getExplanation();
            Summary = CommonUtils.substringChinese(StrUtil.trim((CharSequence)Summary), 20);
            JDomUtils.addChild((Element)rd, (String)"Summary", (String)(CommonUtils.purposeOrSummary("2") ? "" : Summary));
            if (((PaymentInfo)paymentInfos.get(0)).getMerge().booleanValue()) {
                JDomUtils.addChild((Element)rd, (String)"Ref", (String)ICBC_CMP_PayParser.getRef(((PaymentInfo)paymentInfos.get(i)).getBankBatchSeqId()));
            } else {
                JDomUtils.addChild((Element)rd, (String)"Ref", (String)ICBC_CMP_PayParser.getRef(((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqId()));
            }
            if (((PaymentInfo)paymentInfos.get(0)).getMerge().booleanValue()) {
                PaymentUtil.setKdFlagIDByBankBatchSeqID((PaymentInfo)((PaymentInfo)paymentInfos.get(i)));
            } else {
                PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)((PaymentInfo)paymentInfos.get(i)));
            }
            JDomUtils.addChild((Element)rd, (String)"Oref", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ERPSqn", (String)info.getBankDetailSeqID());
            JDomUtils.addChild((Element)rd, (String)"BusCode", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ERPcheckno", (String)"");
            JDomUtils.addChild((Element)rd, (String)"CrvouhType", (String)"");
            JDomUtils.addChild((Element)rd, (String)"CrvouhName", (String)"");
            JDomUtils.addChild((Element)rd, (String)"CrvouhNo", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ReqReserved3", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ReqReserved4", (String)"");
        }
        in.getChild("TotalAmt").setText(PackerUtils.convertYuan2CentStr((BigDecimal)totalAmt));
        String encoding = context.getCharsetName();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg, request.getPaymentInfos());
        return ICBC_CMP_Packer.createMessageWithHeadForPay(msgSigned, this.getBizCode(), "0.0.0.1", 0, ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        ICBC_CMP_PayParser.parsePay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

