/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.icbc.api.response.MybankEnterpriseTradeQhisdResponseV1;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.opa.BankBusinessConfig;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailParser.class);

    public static List<DetailInfo> parse(BankDetailRequest rqst, MybankEnterpriseTradeQhisdResponseV1 response) {
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>(16);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        if (response.isSuccess()) {
            List responseRds = response.getRd();
            if (responseRds == null || responseRds.size() == 0) {
                return list;
            }
            for (MybankEnterpriseTradeQhisdResponseV1.MybankEnterpriseTradeQhisdResponseRdV1 rd : responseRds) {
                String ref;
                DetailInfo info;
                block17: {
                    info = new DetailInfo();
                    info.setAccNo(response.getAccountNo());
                    info.setAccName(rqst.getAcnt().getAccName());
                    info.setCurrency(rd.getThCurrency());
                    info.setOppAccNo(rd.getRecipAccountNo());
                    info.setOppAccName(rd.getRecipName());
                    info.setOppBankName(rd.getRecipBkName());
                    info.setCurrency(rqst.getBankCurrency());
                    String busiDate = rd.getBusiDate();
                    String busiTime = rd.getBusiTime();
                    if (StringUtils.isEmpty((String)busiTime)) {
                        busiTime = "00.00.00";
                    }
                    String transDateTime = busiDate + busiTime;
                    transDateTime = transDateTime.replaceAll("[^0-9]", "");
                    try {
                        if (transDateTime.length() == 14) {
                            info.setTransTime(LocalDateTime.parse(transDateTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                            break block17;
                        }
                        logger.info("length is not 14 :{}", (Object)transDateTime);
                    }
                    catch (DateTimeParseException ee) {
                        logger.error("\u4ea4\u6613\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a" + ee);
                    }
                    continue;
                }
                info.setTransDate(info.getTransTime().toLocalDate());
                info.setExplanation(rd.getSummary() + "-" + rd.getRemark() + "-" + rd.getPostScript());
                info.setBankDetailNo(rd.getOnlySequence());
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Date", (Object)rd.getBusiDate());
                jsonObject.put("Time", (Object)rd.getBusiTime());
                jsonObject.put("OnlySequence", (Object)rd.getOnlySequence());
                jsonObject.put("receiptInfo", (Object)rd.getReceiptInfo());
                jsonObject.put("postscript", (Object)rd.getPostScript());
                jsonObject.put("remark", (Object)rd.getRemark());
                jsonObject.put("summary", (Object)rd.getSummary());
                jsonObject.put("bankCurrency", (Object)rqst.getBankCurrency());
                try {
                    jsonObject.putAll((Map)((JSONObject)JSON.toJSON((Object)rd)));
                }
                catch (Exception e) {
                    logger.error("PutAll error", (Throwable)e);
                }
                info.setJsonMap(jsonObject.toString());
                Long credit = rd.getCreditAmount();
                Long debit = rd.getDebitAmount();
                if (credit == null) {
                    credit = 0L;
                }
                if (debit == null) {
                    debit = 0L;
                }
                BigDecimal creditFee = new BigDecimal(credit);
                BigDecimal debitFee = new BigDecimal(debit);
                String upDtranf = rd.getUpDtranf();
                if ("3".equalsIgnoreCase(upDtranf) && LocalDate.now().isEqual(info.getTransDate())) {
                    creditFee = new BigDecimal(debit);
                    debitFee = new BigDecimal(credit);
                }
                info.setCreditAmount(BigDecimalHelper.div((BigDecimal)creditFee, (BigDecimal)new BigDecimal("100.00")));
                info.setDebitAmount(BigDecimalHelper.div((BigDecimal)debitFee, (BigDecimal)new BigDecimal("100.00")));
                info.setBalance(rd.getBalance() == null ? BigDecimalHelper.ZERO : BigDecimalHelper.div((BigDecimal)new BigDecimal(rd.getBalance()), (BigDecimal)new BigDecimal("100.00")));
                if (Boolean.TRUE.equals(BankBusinessConfig.isNeedTime())) {
                    String time = rd.getTime();
                    info.setBizRefNo(time);
                }
                if (!StringUtils.isEmpty((String)(ref = rd.getRef())) && ref.startsWith("KD_")) {
                    String bankDetailSeqId = ref.substring("KD_".length());
                    DetailSysFiled.set((DetailInfo)info, (String)"KDRetFlag", (String)bankDetailSeqId);
                }
                String jsonStr = jsonObject.toString();
                String dateStr = LocalDateUtil.formatDate((LocalDate)info.getTransDate());
                String receiptNo = MatchRule.getInstance().getReceiptNo(response.getAccountNo(), dateStr, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                info.setReceiptNo(receiptNo);
                list.add(info);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 \u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s\u3002", (String)"DetailParser_3", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]), response.getReturnMsg(), response.getReturnCode(), response.getReturnMsg()));
        }
        return list;
    }
}

