/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.financing.redeem;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.InvestmentEnterpriseFinancialPshuadvsubmitRequestV1;
import com.icbc.api.response.InvestmentEnterpriseFinancialPshuadvsubmitResponseV1;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.opa.service.util.GetStore;
import kd.ebg.aqap.banks.icbc.opa.service.util.TestDateUtil;
import kd.ebg.aqap.business.financing.atomic.AbstractFinancingImpl;
import kd.ebg.aqap.business.financing.atomic.IRedeemFinancing;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.bank.EBBankFinancingResponse;
import kd.ebg.aqap.business.financing.util.FinancingUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import net.sf.json.JSONObject;

public class RedeemFinancingImpl
extends AbstractFinancingImpl
implements IRedeemFinancing {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(RedeemFinancingImpl.class);

    public EBBankFinancingResponse redeemFinancing(BankFinancingRequest request) {
        List fInfos = request.getInfos();
        if (fInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5355\u7b14\u7406\u8d22\u8d4e\u56de\u3002", (String)"RedeemFinancingImpl_0", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
        }
        FinancingInfo fInfo = (FinancingInfo)fInfos.get(0);
        String BASE_URL = GetStore.getBaseUrl();
        String URI = "investment/enterprise/financial/pshuadvsubmit/V1";
        DefaultIcbcClient client = GetStore.getClient();
        try {
            InvestmentEnterpriseFinancialPshuadvsubmitRequestV1.InvestmentEnterpriseFinancialPshuadvsubmitRequestBizV1 bizContent = new InvestmentEnterpriseFinancialPshuadvsubmitRequestV1.InvestmentEnterpriseFinancialPshuadvsubmitRequestBizV1();
            InvestmentEnterpriseFinancialPshuadvsubmitRequestV1 bankRequest = new InvestmentEnterpriseFinancialPshuadvsubmitRequestV1();
            bankRequest.setBizContent((BizContent)bizContent);
            bankRequest.setServiceUrl(BASE_URL + URI);
            Date date = new Date();
            bizContent.setTransCode("PSHUADV");
            bizContent.setTranDate(TestDateUtil.getDate());
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setfSeqNo(request.getBatchSeqId());
            bizContent.setTotalNumber(Integer.valueOf(1));
            bizContent.setAccountNo(fInfo.getAccNo());
            bizContent.setCurrency(fInfo.getCurrency());
            bizContent.setAccountName(fInfo.getAccName());
            ArrayList<InvestmentEnterpriseFinancialPshuadvsubmitRequestV1.InvestmentEnterpriseFinancialPshuadvsubmitRequestRdV1> rds = new ArrayList<InvestmentEnterpriseFinancialPshuadvsubmitRequestV1.InvestmentEnterpriseFinancialPshuadvsubmitRequestRdV1>(1);
            bizContent.setRd(rds);
            InvestmentEnterpriseFinancialPshuadvsubmitRequestV1.InvestmentEnterpriseFinancialPshuadvsubmitRequestRdV1 rd = new InvestmentEnterpriseFinancialPshuadvsubmitRequestV1.InvestmentEnterpriseFinancialPshuadvsubmitRequestRdV1();
            rd.setiSeqNo(fInfo.getDetailBizNo());
            rd.setProductCode(fInfo.getProductCode());
            rd.setErpSeq(fInfo.getDetailBizNo());
            rd.setTerminationQuota(fInfo.getNumber());
            rds.add(rd);
            logger.info("\u7406\u8d22\u4ea7\u54c1\u8d2d\u4e70\u6307\u4ee4\u63d0\u4ea4\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            InvestmentEnterpriseFinancialPshuadvsubmitResponseV1 response = (InvestmentEnterpriseFinancialPshuadvsubmitResponseV1)client.execute((IcbcRequest)bankRequest, Sequence.gen18Sequence());
            logger.info("\u7406\u8d22\u4ea7\u54c1\u8d2d\u4e70\u6307\u4ee4\u63d0\u4ea4\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
            if (response.isSuccess()) {
                FinancingUtil.setState((FinancingInfo)fInfo, (FinancingState)FinancingState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"RedeemFinancingImpl_1", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg(), (String)"");
            } else {
                String retMsg = String.format(ResManager.loadKDString((String)"\u8d4e\u56de\u7406\u8d22\u51fa\u73b0\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u7801\u4e3a%1$s\uff0c\u8fd4\u56de\u4fe1\u606f\u4e3a%2$s\u3002", (String)"RedeemFinancingImpl_4", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]), response.getReturnCode(), response.getReturnMsg());
                FinancingUtil.setState((FinancingInfo)fInfo, (FinancingState)FinancingState.UNKNOWN, (String)retMsg, (String)"", (String)"");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error(e.getCause().toString());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        EBBankFinancingResponse ebBankFinancingResponse = new EBBankFinancingResponse();
        ebBankFinancingResponse.setInfos(fInfos);
        return ebBankFinancingResponse;
    }

    public String pack(BankFinancingRequest bankFinancingRequest) {
        return null;
    }

    public EBBankFinancingResponse parse(BankFinancingRequest bankFinancingRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "PSHUADV";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d4e\u56de\u7406\u8d22\u4ea7\u54c1\u63a5\u53e3\u3002", (String)"RedeemFinancingImpl_3", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(BankFinancingRequest bankFinancingRequest) {
        return false;
    }
}

