/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bbgb.cms.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bbgb.cms.services.detail.RespFileUtils;
import kd.ebg.aqap.banks.bbgb.cms.utils.TCommon;
import kd.ebg.aqap.banks.bbgb.cms.utils.TPacker;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String recv(InputStream inputStream) {
        return TCommon.parseRecvMsg(super.recv(inputStream));
    }

    public String pack(BankDetailRequest req) {
        BankAcnt acnt = req.getAcnt();
        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String tr_code = "200110";
        Element ap = TPacker.createCommonHead(tr_code, req_no);
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)req.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)req.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)req.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return TCommon.createCommonMsg(xmlMsg);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(3);
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ap.getChild("head");
        Element body = ap.getChild("body");
        BankResponse response = TCommon.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u660e\u7ec6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            log.error("###\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u4ea4\u6613\u660e\u7ec6\u3002");
            return new EBBankDetailResponse(details);
        }
        String file_flag = head.getChildTextTrim("file_flag");
        String content = "";
        if ("1".equals(file_flag)) {
            log.info("###\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u6587\u4ef6'");
            String fileName = body.getChildTextTrim("file_name");
            try {
                content = RespFileUtils.getInstance().getRspFileData(fileName);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"###[\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25", (String)"DetailImpl_1", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            log.info("###\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u62a5\u6587'");
            content = body.getChildTextTrim("serial_record");
        }
        String[][] r2 = this.parseRecord(content, recordNum, fieldNum);
        for (int k = 0; k < r2.length; ++k) {
            String[] r2_k = r2[k];
            DetailInfo detailInfo = this.parseR2(r2_k);
            details.add(detailInfo);
        }
        log.info("===\u89e3\u6790<\u4ea4\u6613\u660e\u7ec6>\u62a5\u6587\u7ed3\u675f===");
        return new EBBankDetailResponse(details);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200110";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u660e\u7ec6(200110\u4ea4\u6613)", (String)"DetailImpl_2", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]);
    }

    private DetailInfo parseR2(String[] r2_k) {
        String acno = r2_k[1];
        String tr_currency = r2_k[2];
        String tr_acdt = r2_k[3];
        String tr_time = r2_k[4];
        String host_serial_no = r2_k[5];
        String tranDate = tr_acdt + tr_time;
        String acname = r2_k[7];
        String opp_acno = r2_k[8];
        String opp_acname = r2_k[10];
        String oppBank = r2_k[11];
        String crdr_flag = r2_k[23];
        String amt = r2_k[24];
        String balance = r2_k[25];
        String summary = r2_k[34];
        String postscript = r2_k[35];
        String rcvamt = r2_k[41];
        String payamt = r2_k[40];
        DetailInfo detailInfo = new DetailInfo();
        detailInfo.setAccNo(acno);
        detailInfo.setAccName(acname);
        detailInfo.setOppAccNo(opp_acno);
        detailInfo.setOppAccName(opp_acname);
        detailInfo.setOppBankName(oppBank);
        detailInfo.setCurrency(tr_currency);
        detailInfo.setTransDate(LocalDate.parse(tr_acdt, DateTimeFormatter.ofPattern("yyyyMMdd")));
        detailInfo.setTransTime(LocalDateTime.parse(tranDate, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("host_serial_no", (Object)host_serial_no);
        jsonObject.put("tr_acdt", (Object)tr_acdt);
        jsonObject.put("rcvamt", (Object)rcvamt);
        jsonObject.put("payamt", (Object)payamt);
        jsonObject.put("summary", (Object)summary);
        jsonObject.put("postscript", (Object)postscript);
        detailInfo.setJsonMap(jsonObject.toString());
        detailInfo.setBankDetailNo(host_serial_no);
        if (!StringUtils.isEmpty((String)payamt)) {
            detailInfo.setDebitAmount(new BigDecimal(payamt));
        }
        if (!StringUtils.isEmpty((String)rcvamt)) {
            detailInfo.setCreditAmount(new BigDecimal(rcvamt));
        }
        detailInfo.setExplanation(summary);
        detailInfo.setBalance(new BigDecimal(balance));
        return detailInfo;
    }

    private String[][] parseRecord(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];
            }
        }
        return r2;
    }
}

