/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bbgb.cms.services.payment.allocation;

import java.io.InputStream;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bbgb.cms.services.payment.allocation.QryAllocPaymentImpl;
import kd.ebg.aqap.banks.bbgb.cms.utils.TCommon;
import kd.ebg.aqap.banks.bbgb.cms.utils.TPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocPaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(AllocPaymentImpl.class);

    public String recv(InputStream inputStream) {
        return TCommon.parseRecvMsg(super.recv(inputStream));
    }

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryAllocPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String tr_code = "300216";
        Element ap = TPacker.createCommonHead(tr_code, paymentInfo.getPackageId());
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"rcv_acno", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcv_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"rcv_acname", (String)paymentInfo.getIncomeAccName());
        String amount = paymentInfo.getAmount().setScale(2, 1).toPlainString();
        JDomUtils.addChild((Element)body, (String)"amt", (String)amount);
        JDomUtils.addChild((Element)body, (String)"transtype", (String)this.getTransType(paymentInfo.getUseCn()));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        log.info("---\u5212\u62e8:" + xmlMsg);
        return TCommon.createCommonMsg(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = TCommon.parseBankResponse(head);
        if ("0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String getTransType(String type) {
        if (StringUtils.isEmpty((String)type)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AllocPaymentImpl_2", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]));
        }
        if (!ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"AllocPaymentImpl_3", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]).equals(type) && !ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u62e8", (String)"AllocPaymentImpl_4", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]).equals(type)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7528\u9014\u548c\u5212\u62e8\u4e0d\u7b26\u3002", (String)"AllocPaymentImpl_5", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]));
        }
        if (ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"AllocPaymentImpl_3", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]).equals(type)) {
            return "0";
        }
        if (ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u62e8", (String)"AllocPaymentImpl_4", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]).equals(type)) {
            return "1";
        }
        return "";
    }
}

