/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bcs.cmp.services.payment.query;

import java.io.InputStream;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bcs.cmp.utils.Constant;
import kd.ebg.aqap.banks.bcs.cmp.utils.Packer;
import kd.ebg.aqap.banks.bcs.cmp.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OtherAndSameBankPaymentQueryImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(OtherAndSameBankPaymentQueryImpl.class);

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = Packer.buildHead("00003020104A0239", Sequence.genSequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"reqDate", (String)paymentInfo.getSubmitSuccessTime().format(Constant.dateFormat));
        JDomUtils.addChild((Element)body, (String)"reqSerialNo", (String)paymentInfo.getBankBatchSeqId());
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        logger.info("\u72b6\u6001:" + bankResponse.getResponseCode());
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            logger.info("\u4ea4\u6613\u72b6\u6001:\u4ea4\u6613\u672a\u786e\u8ba4");
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"OtherAndSameBankPaymentQueryImpl_0", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = root.getChild("body");
        String JnlStat = body.getChildTextTrim("jnlStat");
        String jnlMsg = body.getChildTextTrim("jnlMsg");
        logger.info("\u539f\u4ea4\u6613\u72b6\u6001:" + JnlStat);
        if ("S".equals(JnlStat)) {
            logger.info("\u4ea4\u6613\u72b6\u6001:\u4ea4\u6613\u6210\u529f");
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)JnlStat, (String)jnlMsg);
        } else if ("F".equals(JnlStat)) {
            logger.info("\u4ea4\u6613\u72b6\u6001:\u4ea4\u6613\u5931\u8d25");
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)JnlStat, (String)jnlMsg);
        } else if ("A".equals(JnlStat) || "P".equals(JnlStat) || "W".equals(JnlStat)) {
            logger.info("\u4ea4\u6613\u72b6\u6001:\u94f6\u884c\u5904\u7406\u4e2d");
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)JnlStat, (String)jnlMsg);
        } else {
            logger.info("\u4ea4\u6613\u72b6\u6001:\u4ea4\u6613\u672a\u786e\u8ba4");
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)JnlStat, (String)jnlMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "00003020104A0239";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4f01\u4e1a\u4ea4\u6613\u6d41\u6c34\u72b6\u6001 (03020104A0239\u4ea4\u6613)", (String)"OtherAndSameBankPaymentQueryImpl_1", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]);
    }
}

