/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bcs.cmp.services.payment.salary;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bcs.cmp.services.payment.ProxyUpload;
import kd.ebg.aqap.banks.bcs.cmp.services.payment.query.SalaryAndBatchPaymentQueryImpl;
import kd.ebg.aqap.banks.bcs.cmp.utils.Packer;
import kd.ebg.aqap.banks.bcs.cmp.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.codec.binary.Base64;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }

    public int getBatchSize() {
        return 300;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryAndBatchPaymentQueryImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        BigDecimal totalAmt = BigDecimal.ZERO;
        LinkedList cellValues = new LinkedList();
        for (PaymentInfo info : paymentInfos) {
            HashMap<String, String> cell = new HashMap<String, String>();
            cell.put("0", info.getIncomeAccNo());
            cell.put("1", info.getIncomeAccName());
            cell.put("2", info.getAmount().toPlainString());
            cell.put("3", "");
            cell.put("4", info.getExplanation());
            cellValues.add(cell);
            totalAmt = totalAmt.add(info.getAmount());
        }
        String excelHeader = ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7|\u6536\u6b3e\u6237\u540d|\u6536\u6b3e\u91d1\u989d|\u6536\u6b3e\u4eba\u624b\u673a\u53f7|\u6458\u8981", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]);
        String fileName = paymentInfo.getBankBatchSeqId() + ".xlsx";
        ProxyUpload proxyUpload = new ProxyUpload();
        proxyUpload.setFileContent(Base64.encodeBase64String((byte[])JSON.toJSONBytes(cellValues, (SerializerFeature[])new SerializerFeature[0])));
        proxyUpload.setExcelHeader(Base64.encodeBase64String((byte[])excelHeader.getBytes()));
        proxyUpload.doBiz(fileName);
        Element root = Packer.buildHead("00003020104B0214", paymentInfo.getBankBatchSeqId(), "0", "1");
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"visible", (String)"0");
        JDomUtils.addChild((Element)body, (String)"batchNo", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"tfrType", (String)"1");
        JDomUtils.addChild((Element)body, (String)"currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"acctName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"totalAmt", (String)totalAmt.toPlainString());
        JDomUtils.addChild((Element)body, (String)"totalCount", (String)(paymentInfos.size() + ""));
        JDomUtils.addChild((Element)body, (String)"summary", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)"");
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return Parser.payResponse(bankPayRequest, s);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "00003020104B0214";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"00003020104B0214 \u6279\u91cf\u4ee3\u53d1", (String)"PaymentImpl_4", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

