/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.srcb.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.srcb.dc.services.Packer;
import kd.ebg.aqap.banks.srcb.dc.services.Parser;
import kd.ebg.aqap.banks.srcb.dc.services.login.LoginAccess;
import kd.ebg.aqap.banks.srcb.dc.services.login.LoginAccessManager;
import kd.ebg.aqap.banks.srcb.dc.services.utils.DecryUtil;
import kd.ebg.aqap.banks.srcb.dc.services.utils.EncryUtil;
import kd.ebg.aqap.banks.srcb.dc.services.utils.SmUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        LoginAccess loginAccess = LoginAccessManager.searchLock();
        Element root = Packer.packHeader(this.getBizCode(), loginAccess.getToken());
        Element envelope = root.getChild("Envelope");
        Element body = JDomUtils.addChild((Element)envelope, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"AcctType", (String)"20");
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String request = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        String sign = SmUtil.sign(request);
        this.logger.info("\u52a0\u5bc6\u524d\u62a5\u6587:{}", (Object)sign);
        String encry = EncryUtil.encry(sign);
        return RequestContextUtils.getBankParameterValue((String)"BankCertId") + encry;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String response) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        EBContext context = EBContext.getContext();
        String decry = "";
        if (context.isUnitTest()) {
            decry = context.getUnitTestData();
        } else {
            decry = DecryUtil.decry(response);
            boolean verify = SmUtil.verify(decry);
            if (!verify) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u54cd\u5e94\u62a5\u6587\u9a8c\u7b7e\u5931\u8d25\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]));
            }
        }
        String realResponseMsg = Parser.getRealResponseMsg(decry);
        Element root = JDomUtils.string2Root((String)realResponseMsg, (String)RequestContextUtils.getCharset());
        Element envelope = root.getChild("Envelope");
        Element header = envelope.getChild("Header");
        Element body = envelope.getChild("Body");
        String resultCode = header.getChildTextTrim("ResultCode");
        String resultMessage = header.getChildTextTrim("ResultMessage");
        if (!"000000".equalsIgnoreCase(resultCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u7801:%1$s\uff0c\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"DetailImpl_4", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]), resultCode, resultMessage));
        }
        Element rowset = body.getChild("rowset");
        List rows = rowset.getChildren("row");
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(100);
        for (int i = 0; i < rows.size(); ++i) {
            DetailInfo detailInfo = new DetailInfo();
            Element row = (Element)rows.get(i);
            String tranDate = row.getChildText("TranDate");
            String tranTime = row.getChildText("TranTime");
            String dbtAcct = row.getChildText("DbtAcct");
            String dbtAcctName = row.getChildText("DbtAcctName");
            String dbtBankName = row.getChildText("DbtBankName");
            String crtAcct = row.getChildText("CrtAcct");
            String crtAcctName = row.getChildText("CrtAcctName");
            String crtBankName = row.getChildText("CrtBankName");
            String amount = row.getChildText("Amount");
            String currency = row.getChildText("Currency");
            String loanFlag = row.getChildText("LoanFlag");
            String balance = row.getChildText("Balance");
            String remark = row.getChildText("Remark");
            detailInfo.setTransDate(LocalDate.parse(tranDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detailInfo.setTransTime(LocalDateTime.parse(tranTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            detailInfo.setAccNo(dbtAcct);
            detailInfo.setAccName(dbtAcctName);
            detailInfo.setBankName(dbtBankName);
            detailInfo.setOppAccNo(crtAcct);
            detailInfo.setOppAccName(crtAcctName);
            detailInfo.setOppBankName(crtBankName);
            BigDecimal amountBd = ParserUtils.convertCentStr2Yuan((String)amount);
            if ("C".equalsIgnoreCase(loanFlag)) {
                detailInfo.setCreditAmount(amountBd);
                detailInfo.setDebitAmount(ParserUtils.ZERO);
            } else if ("D".equalsIgnoreCase(loanFlag)) {
                detailInfo.setCreditAmount(ParserUtils.ZERO);
                detailInfo.setDebitAmount(amountBd);
            }
            detailInfo.setCurrency(currency);
            detailInfo.setBalance(ParserUtils.convertCentStr2Yuan((String)balance));
            detailInfo.setExplanation(remark);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            detailInfo.setJsonMap(jsonStr);
            detailList.add(detailInfo);
        }
        this.logger.info("\u89e3\u6790\u5230\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u660e\u7ec6\u6761\u6570:{}", (Object)detailList.size());
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "21002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_3", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml;charset=utf-8");
    }
}

