/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjrc.dc.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjrc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.allocation.AllocationPayImpl;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.allocation.AllocationQueryPayImpl;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.batch.BatchPayImpl;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.batch.BatchQueryPayImpl;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.company.CompanyPayImpl;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.individual.IndividualPayImpl;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.individual.IndividualQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PretreatmentImpl
implements IPretreat {
    public String getDeveloper() {
        return "Jimmy";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        StringBuilder packageKey = new StringBuilder();
        packageKey.append("accNo=");
        packageKey.append(paymentInfo.getAccNo());
        packageKey.append(";");
        packageKey.append("urgent=");
        packageKey.append(paymentInfo.is2Urgent());
        packageKey.append(";");
        packageKey.append("sameBank=").append(paymentInfo.getSameBank()).append(";").append("bizType=").append(paymentInfo.getBizType()).append(";").append("subBizType=").append(paymentInfo.getSubBizType()).append(";").append("individual=").append(paymentInfo.is2Individual()).append(";");
        String subBizType = paymentInfo.getSubBizType();
        if ("pay_for_salary".equalsIgnoreCase(subBizType)) {
            this.setSubBizType4Salary(busiImplInfo);
        } else if ("pay_for_capital_allocation".equalsIgnoreCase(subBizType)) {
            this.setSubBizType4CapitalAllocation(busiImplInfo);
        } else if ("pay".equalsIgnoreCase(subBizType)) {
            if (BankBusinessConfig.isMatchCompanyAcc(paymentInfo.getIncomeAccNo())) {
                busiImplInfo.setImplName(AllocationPayImpl.class.getName());
                busiImplInfo.setQueryImplName(AllocationQueryPayImpl.class.getName());
            } else if (UseConvertor.isTransfer((PaymentInfo)paymentInfo)) {
                this.setSubBizType4CapitalAllocation(busiImplInfo);
            } else {
                busiImplInfo.setImplName(BatchPayImpl.class.getName());
                busiImplInfo.setQueryImplName(BatchQueryPayImpl.class.getName());
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%s, \u8bf7\u68c0\u67e5\u8be5\u4e1a\u52a1\u7c7b\u578b\u662f\u5426\u6b63\u786e.", (String)"PretreatmentImpl_2", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), subBizType));
        }
        paymentInfo.setPackageKey(packageKey.toString());
        busiImplInfo.setPackageKey(packageKey.toString());
        return busiImplInfo;
    }

    public void appendData(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = this.getBusiImplInfo(paymentInfo);
        paymentInfo.setImplClassName(busiImplInfo.getImplName());
        paymentInfo.setQueryImplClassName(busiImplInfo.getQueryImplName());
        paymentInfo.setPackageKey(busiImplInfo.getPackageKey());
    }

    private void setSubBizType4Salary(BusiImplInfo busiImplInfo) {
        busiImplInfo.setImplName(IndividualPayImpl.class.getName());
        busiImplInfo.setQueryImplName(IndividualQueryPayImpl.class.getName());
    }

    private void setSubBizType4CapitalAllocation(BusiImplInfo busiImplInfo) {
        if (BankBusinessConfig.isTransferToCompany()) {
            busiImplInfo.setImplName(CompanyPayImpl.class.getName());
            busiImplInfo.setQueryImplName(CompanyQueryPayImpl.class.getName());
        } else {
            busiImplInfo.setImplName(AllocationPayImpl.class.getName());
            busiImplInfo.setQueryImplName(AllocationQueryPayImpl.class.getName());
        }
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

