/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000003_Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.Root;
import kd.ebg.aqap.banks.bsz.dc.helper.Packer;
import kd.ebg.aqap.banks.bsz.dc.helper.Parser;
import kd.ebg.aqap.banks.bsz.dc.utils.ApiUtils;
import kd.ebg.aqap.banks.bsz.dc.utils.Utils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        return null;
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        try {
            Map bodyMap = Packer.getSendObject(request, this.getBizCode());
            logger.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)bodyMap.toString());
            String responseStr = ApiUtils.doPostRequest(bodyMap);
            logger.info("\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)responseStr);
            return this.parse(request, responseStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage());
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        try {
            Root root = Parser.getRecvObject(responseStr, this.getBizCode());
            return this.recvStrategy(root, request);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage());
        }
    }

    public EBBankBalanceResponse recvStrategy(Root<Header4Receive, OPCB000003_Receive> root, BankBalanceRequest request) throws Exception {
        BalanceInfo balance = new BalanceInfo();
        Header4Receive header = root.getHeader();
        OPCB000003_Receive body = root.getBody();
        String headStatusCode = Utils.nullAsBlank(header.getRET_CODE());
        String headStatusMsg = Utils.nullAsBlank(header.getRET_MSG());
        Utils.checkRspCode(headStatusCode, headStatusMsg, "000000");
        if (Utils.allfieldIsNUll(body)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587header\u72b6\u6001\u4e3a000000\uff0c\u4f46body\u4e3a\u7a7a\uff0c\u9700\u8be6\u8be2\u94f6\u884c\uff01", (String)"OPCB000003_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        String accName = Utils.nullAsBlank(body.getACCT_NAME());
        String accNo = Utils.nullAsBlank(body.getCLIENT_ACCT_NO());
        String balanceStr = Utils.nullAsBlank(body.getPRESENT_BALANCE());
        String aviBalanceStr = Utils.nullAsBlank(body.getTODAY_AVAIL_AMT());
        String currency = Utils.nullAsBlank(body.getCCY());
        logger.info("\u4f59\u989d\u4fe1\u606f.\u8fd4\u56de\u8d26\u53f7:" + accNo + ",\u4f59\u989d:" + balanceStr + ",\u53ef\u7528\u989d\u5ea6:" + aviBalanceStr);
        this.setCurrentBalance(balance, balanceStr);
        this.setAvailableBalance(balance, aviBalanceStr);
        this.setBankAcnt(balance, request.getBankAcntList(), accNo);
        balance.setBalanceDateTime(LocalDateTime.now());
        this.setBankCurrency(balance, currency);
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "OPCB000003";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4eca\u65e5\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_3", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]);
    }
}

