/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.services.interfaces;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Send;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000001_Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000001_Send;
import kd.ebg.aqap.banks.bsz.dc.bean.Root;
import kd.ebg.aqap.banks.bsz.dc.constants.BSZConstants;
import kd.ebg.aqap.banks.bsz.dc.helper.Dealer;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.IMiniService;
import kd.ebg.aqap.banks.bsz.dc.utils.Utils;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OPCB000001
implements IMiniService<Root<Header4Send, OPCB000001_Send>, Root<Header4Receive, OPCB000001_Receive>, List<PaymentInfo>, List<PaymentInfo>> {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(OPCB000001.class);
    public static String transCode = "OPCB000001";

    public static OPCB000001 getInstance() {
        return Holder.instance;
    }

    @Override
    public Root<Header4Send, OPCB000001_Send> getSendRoot(List<PaymentInfo> paymentInfos) throws Exception {
        Root<Header4Send, OPCB000001_Send> root = new Root<Header4Send, OPCB000001_Send>();
        PaymentInfo info = paymentInfos.get(0);
        OPCB000001_Send body = new OPCB000001_Send();
        body.setPAYER_ACCT_NO(info.getAccNo());
        body.setPAYER_NAME(info.getAccName());
        if (!info.is2SameBank()) {
            body.setPAYEE_OPEN_BRANCH_ID(info.getIncomeCnaps());
            body.setPAYEE_OPEN_BRANCH_NAME(info.getIncomeBankAddress());
        }
        body.setPAYEE_ACCT_NO(info.getIncomeAccNo());
        body.setPAYEE_NAME(info.getIncomeAccName());
        if (!info.getCurrency().equals("156")) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u5728\u5e01\u79cd\u6620\u5c04\u7ba1\u7406\u4e2d\u68c0\u67e5\u5e01\u79cd\u6620\u5c04\uff0c\u82cf\u5dde\u94f6\u884c\u76ee\u524d\u4ec5\u652f\u6301\u4eba\u6c11\u5e01\uff0c\u5bf9\u5e94\u7684\u5e01\u79cd\u7f16\u53f7\u4e3a156", (String)"OPCB000001_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        body.setCCY(info.getCurrency());
        if (info.is2SameCity()) {
            body.setPAYEE_ACCT_TYPE(info.is2Individual() ? "1" : "0");
        }
        body.setTRAN_TYPE(Dealer.chooseTransType(info, false));
        body.setTRAN_AMT(info.getAmount().toString());
        String usage = "";
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)info);
            usage = BizNoUtil.cont((String)info.getBankDetailSeqId(), (String)info.getExplanation());
        } else {
            usage = info.getExplanation();
        }
        body.setUSAGE(usage);
        body.setPOSTSCRIPT(info.getExplanation());
        root.setBody(body);
        return root;
    }

    @Override
    public Root<Header4Receive, OPCB000001_Receive> getrecvRoot(String rspStr) {
        Root root = (Root)JSON.parseObject((String)rspStr, (TypeReference)new TypeReference<Root<Header4Receive, OPCB000001_Receive>>(){}, (Feature[])new Feature[0]);
        return root;
    }

    @Override
    public List<PaymentInfo> recvStrategy(Root<Header4Receive, OPCB000001_Receive> root, List<PaymentInfo> paymentInfos) throws Exception {
        String bodyStatusCode;
        String bodyStatusExpr;
        Header4Receive header = root.getHeader();
        OPCB000001_Receive body = root.getBody();
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String headStatusCode = Utils.nullAsBlank(header.getRET_CODE());
        String headStatusMsg = Utils.nullAsBlank(header.getRET_MSG());
        Utils.checkRspCode(headStatusCode, headStatusMsg, "000000");
        if (Utils.allfieldIsNUll(body)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"body\u8282\u70b9\u4e0d\u5b58\u5728", (String)"OPCB000001_1", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), (String)headStatusCode, (String)headStatusMsg);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587header\u72b6\u6001\u4e3a000000\uff0c\u4f46body\u4e3a\u7a7a\uff0c\u9700\u8be6\u8be2\u94f6\u884c\uff01", (String)"OPCB000001_2", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        String ORDER_FLOWNO = Utils.nullAsBlank(body.getORDER_FLOWNO());
        String CONSUMER_SEQ_NO = Utils.nullAsBlank(header.getCONSUMER_SEQ_NO());
        if (!StringUtils.isEmpty((String)ORDER_FLOWNO)) {
            PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"ORDER_FLOWNO", (String)ORDER_FLOWNO);
            PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"CONSUMER_SEQ_NO", (String)CONSUMER_SEQ_NO);
            PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"PAY_TRANSCODE", (String)this.getTransCode());
        }
        if (StringUtils.isEmpty((String)(bodyStatusExpr = Utils.nullAsBlank(BSZConstants.STATUS_MAP.get(bodyStatusCode = Utils.nullAsBlank(body.getRET_STATE())).loadKDString())))) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u65e0\u6cd5\u8bc6\u522b\u72b6\u6001\u7801:%s", (String)"OPCB000001_3", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), bodyStatusCode), (String)headStatusCode, (String)headStatusMsg);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u65e0\u6cd5\u8bc6\u522bbody\u72b6\u6001\u7801\uff1a%s", (String)"OPCB000001_4", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), bodyStatusCode));
        }
        if (bodyStatusCode.equals("90")) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)bodyStatusExpr, (String)bodyStatusCode, (String)headStatusMsg);
        } else if (bodyStatusCode.equals("91")) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)bodyStatusExpr, (String)bodyStatusCode, (String)headStatusMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)bodyStatusExpr, (String)bodyStatusCode, (String)headStatusMsg);
        }
        return paymentInfos;
    }

    @Override
    public String getTransCode() {
        return transCode;
    }

    private static class Holder {
        private static final OPCB000001 instance = new OPCB000001();

        private Holder() {
        }
    }
}

