/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.services.interfaces;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Send;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000024_Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000024_ReceiveItem;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000024_Send;
import kd.ebg.aqap.banks.bsz.dc.bean.Root;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.IMiniService;
import kd.ebg.aqap.banks.bsz.dc.utils.Utils;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OPCB000024
implements IMiniService<Root<Header4Send, OPCB000024_Send>, Root<Header4Receive, OPCB000024_Receive>, BankDetailRequest, List<DetailInfo>> {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(OPCB000024.class);
    private static OPCB000024 instance;
    public static String transCode;

    public static OPCB000024 getInstance() {
        return Holder.instance;
    }

    @Override
    public Root<Header4Send, OPCB000024_Send> getSendRoot(BankDetailRequest rqst) throws Exception {
        OPCB000024_Send body = new OPCB000024_Send();
        body.setACCT_NO(rqst.getAcnt().getAccNo());
        body.setSTART_DATE(LocalDateUtil.formatDate((LocalDate)rqst.getStartDate()));
        body.setEND_DATE(LocalDateUtil.formatDate((LocalDate)rqst.getEndDate()));
        body.setCCY(Utils.nullAsBlank(rqst.getBankCurrency()));
        body.setCA_TT_FLAG(body.getCCY().equals("156") ? "1" : "2");
        body.setSORT_MODE("2");
        Root<Header4Send, OPCB000024_Send> root = new Root<Header4Send, OPCB000024_Send>();
        root.setBody(body);
        return root;
    }

    @Override
    public Root<Header4Receive, OPCB000024_Receive> getrecvRoot(String rspStr) {
        Root root = (Root)JSON.parseObject((String)rspStr, (TypeReference)new TypeReference<Root<Header4Receive, OPCB000024_Receive>>(){}, (Feature[])new Feature[0]);
        return root;
    }

    @Override
    public List<DetailInfo> recvStrategy(Root<Header4Receive, OPCB000024_Receive> root, BankDetailRequest rqst) throws Exception {
        Header4Receive header = root.getHeader();
        OPCB000024_Receive body = root.getBody();
        String headStatusCode = Utils.nullAsBlank(header.getRET_CODE());
        String headStatusMsg = Utils.nullAsBlank(header.getRET_MSG());
        if (headStatusCode.equals("HDQP2001")) {
            return new ArrayList<DetailInfo>(1);
        }
        Utils.checkRspCode(headStatusCode, headStatusMsg, "000000");
        if (Utils.allfieldIsNUll(body)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587header\u72b6\u6001\u4e3a000000\uff0c\u4f46body\u4e3a\u7a7a\uff0c\u9700\u8be6\u8be2\u94f6\u884c\uff01", (String)"OPCB000024_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        List<OPCB000024_ReceiveItem> items = body.getTRAN_LIST_ARRAY();
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>();
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        if (items != null && !items.isEmpty()) {
            for (OPCB000024_ReceiveItem item : items) {
                DetailInfo info = new DetailInfo();
                try {
                    info.setAccNo(Utils.nullAsBlank(item.getACCT_NO()));
                    String date = Utils.nullAsBlank(item.getORI_TRAN_DATE());
                    String time = Utils.nullAsBlank(item.getMACHINE_TIME());
                    info.setTransDate(LocalDateUtil.parserDate((String)date));
                    info.setTransTime(Utils.parserDateTime(time, "yyyy-MM-dd-HH.mm.ss"));
                    String DR_CR_FLAG = item.getDR_CR_FLAG();
                    String amt = item.getOCCUR_AMT();
                    String CCY = item.getCCY();
                    info.setCurrency(CCY);
                    if ("D".equals(DR_CR_FLAG)) {
                        info.setDebitAmount(new BigDecimal(amt));
                        info.setCreditAmount(new BigDecimal("0.0"));
                    } else if ("C".equals(DR_CR_FLAG)) {
                        info.setCreditAmount(new BigDecimal(amt));
                        info.setDebitAmount(new BigDecimal("0.0"));
                    } else {
                        throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getDetailCDFlagErrorTips((String)DR_CR_FLAG));
                    }
                    String bal = Utils.nullAsBlank(item.getBALANCE());
                    if (!StringUtils.isEmpty((String)bal)) {
                        info.setBalance(new BigDecimal(bal));
                    }
                    info.setOppAccNo(Utils.nullAsBlank(item.getCOUNTER_ACCT_NO()));
                    String REMARK = item.getREMARK();
                    String REMARK_CODE_NAME = item.getREMARK_CODE_NAME();
                    info.setOppAccName(Utils.nullAsBlank(item.getCOUNTER_ACCT_NAME()));
                    info.setOppBankName(Utils.nullAsBlank(item.getCOUNTER_BRANCH_NAME()));
                    String usage = Utils.nullAsBlank(REMARK);
                    String explanation = Utils.nullAsBlank(REMARK_CODE_NAME);
                    if (!StringUtils.isEmpty((String)BizNoUtil.getId((String)usage))) {
                        String batchNO = BizNoUtil.getId((String)usage);
                        explanation = BizNoUtil.getMsg((String)usage);
                        info.setKdFlag(batchNO);
                        info.setPayBankDetailSeqID(batchNO);
                    }
                    info.setExplanation(explanation);
                    String LOG_NO = Utils.nullAsBlank(item.getLOG_NO());
                    String LOG_SEQ_NO = Utils.nullAsBlank(item.getLOG_SEQ_NO());
                    info.setBankDetailNo(LOG_NO);
                    String jsonStr = JSON.toJSONString((Object)item);
                    JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                    jsonObject.put("LOG_SERIAL_NO", (Object)LOG_NO);
                    try {
                        String logNo = new BigDecimal(LOG_NO).toPlainString();
                        jsonObject.put("LOG_NO", (Object)logNo);
                        jsonStr = jsonObject.toJSONString();
                    }
                    catch (Exception e) {
                        logger.error("\u6d41\u6c34\u53f7\u8f49\u5316\u5931\u6557");
                    }
                    String transDateStr = LocalDateUtil.formatDate((LocalDate)info.getTransDate());
                    String receiptNo = MatchRule.getInstance().getReceiptNo(rqst.getAcnt().getAccNo(), transDateStr, jsonStr);
                    info.setJsonMap(jsonObject.toJSONString());
                    if (countMap.containsKey(receiptNo)) {
                        int count = (Integer)countMap.get(receiptNo) + 1;
                        countMap.put(receiptNo, count);
                        receiptNo = receiptNo + "-" + String.format("%04d", count);
                    } else {
                        countMap.put(receiptNo, 0);
                    }
                    info.setReceiptNo(receiptNo);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    continue;
                }
                detailInfos.add(info);
            }
        }
        return detailInfos;
    }

    @Override
    public String getTransCode() {
        return transCode;
    }

    static {
        transCode = "OPCB000024";
    }

    private static class Holder {
        private static final OPCB000024 instance = new OPCB000024();

        private Holder() {
        }
    }
}

