/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jsb.cmp.service.detail;

import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jsb.cmp.service.util.Packer;
import kd.ebg.aqap.banks.jsb.cmp.service.util.Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final Logger logger = LoggerFactory.getLogger(DetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> processDetail(BankDetailRequest request) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        this.setCurrentPage("1");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse response = this.doBiz(request);
            if (!Objects.nonNull(response) || !Objects.nonNull(response.getDetails())) continue;
            detailInfos.addAll(response.getDetails());
        }
        return detailInfos;
    }

    public String pack(BankDetailRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = Packer.buildHead("00003020101A0007", Sequence.gen18Sequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"currency", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"startDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"start", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"size", (String)"10");
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlStr);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        if (StringUtils.isEmpty((String)this.getCurrentPage())) {
            this.setCurrentPage("1");
        }
        EBBankDetailResponse detailResponse = new EBBankDetailResponse();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            this.setLastPage(true);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u8d26\u53f7(%1$s)\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\u3002\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u4ea4\u6613\u72b6\u6001[%2$s]\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u3002", (String)"DetailImpl_5", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]), request.getAcnt().getAccNo(), StringUtils.catWithSpace((String[])new String[]{bankResponse.getResponseCode(), bankResponse.getResponseMessage()})));
        }
        Element body = root.getChild("body");
        List dtoList = body.getChild("array").getChildren("dto");
        if (dtoList.size() == 0) {
            detailResponse.setDetails(new ArrayList(1));
            this.setCurrentPage("1");
            this.setLastPage(true);
            return detailResponse;
        }
        this.setCurrentPage(String.valueOf(Integer.parseInt(this.getCurrentPage()) + Integer.parseInt("10")));
        int total = Integer.parseInt(body.getChildTextTrim("TotRcrdCnt"));
        this.setLastPage(total < Integer.parseInt(this.getCurrentPage()));
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(dtoList.size());
        for (int i = 0; i < dtoList.size(); ++i) {
            Element dto = (Element)dtoList.get(i);
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(dto.getChildTextTrim("currency"));
            detail.setOppAccNo(dto.getChildTextTrim("oppAcctNo"));
            detail.setOppAccName(dto.getChildTextTrim("oppAcctName"));
            detail.setOppBankName(dto.getChildTextTrim("oppBankName"));
            detail.setAccName(dto.getChildTextTrim("acctName"));
            detail.setAccNo(request.getAcnt().getAccNo());
            String transferDate = dto.getChildTextTrim("trDate");
            String transferTime = dto.getChildTextTrim("trTime");
            String hostSerialNo = dto.getChildTextTrim("hostSerialNo");
            detail.setTransDate(LocalDate.parse(transferDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setTransTime(LocalDateTime.parse(transferDate + transferTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            BigDecimal amount = new BigDecimal(dto.getChildTextTrim("amt"));
            String CDFlag = dto.getChildTextTrim("drcrFlag");
            if (CDFlag.equalsIgnoreCase("D")) {
                detail.setDebitAmount(amount);
                detail.setCreditAmount(new BigDecimal(0));
            } else if (CDFlag.equalsIgnoreCase("C")) {
                detail.setDebitAmount(new BigDecimal(0));
                detail.setCreditAmount(amount);
            }
            detail.setExplanation(dto.getChildTextTrim("summary"));
            String balance = dto.getChildTextTrim("balance");
            if (StringUtils.isNotEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(dto);
            detail.setJsonMap(jsonStr);
            detail.setBankDetailNo(hostSerialNo);
            String receiptNo = MatchRule.getInstance().getReceiptNo(detail.getAccNo(), transferDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            totalList.add(detail);
        }
        detailResponse.setDetails(totalList);
        if (request.getAcnt().getAccName().equals(PropertiesConstants.getValue((String)"UNIT_TEST"))) {
            this.setCurrentPage("10");
            this.setLastPage(true);
        }
        return detailResponse;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "03020101A0007";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_4", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }
}

