/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.dc.service.payment.oversea;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.ebg.aqap.banks.hsbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsbc.dc.service.HSBC_DC_Parser;
import kd.ebg.aqap.banks.hsbc.dc.service.payment.oversea.OverSeaQueryPayImpl;
import kd.ebg.aqap.banks.hsbc.dc.utils.PaymentUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverSeaPayImpl
extends AbstractPayImpl
implements IPay {
    private static Logger logger = LoggerFactory.getLogger(OverSeaPayImpl.class);

    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return BankBusinessConfig.getBatchNumber();
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return OverSeaQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Namespace ns2 = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Element root = JDomUtils.createRoot((String)"Document");
        root.setNamespace(ns1);
        root.addNamespaceDeclaration(ns2);
        Document document = new Document(root);
        Element CstmrCdtTrfInitn = JDomUtils.addChild((Element)root, (String)"CstmrCdtTrfInitn").setNamespace(ns1);
        Element GrpHdr = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"GrpHdr").setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"MsgId", (String)paymentInfo.getBankBatchSeqID()).setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"CreDtTm", (String)LocalDateTime.now().withNano(0).toString()).setNamespace(ns1);
        Element NbOfTxs = JDomUtils.addChild((Element)GrpHdr, (String)"NbOfTxs").setNamespace(ns1);
        NbOfTxs.addContent(String.valueOf(paymentInfos.size()));
        Element CtrlSum = JDomUtils.addChild((Element)GrpHdr, (String)"CtrlSum").setNamespace(ns1);
        Element InitgPty = JDomUtils.addChild((Element)GrpHdr, (String)"InitgPty").setNamespace(ns1);
        Element Id = JDomUtils.addChild((Element)InitgPty, (String)"Id").setNamespace(ns1);
        Element OrgId = JDomUtils.addChild((Element)Id, (String)"OrgId").setNamespace(ns1);
        Element Othr = JDomUtils.addChild((Element)OrgId, (String)"Othr").setNamespace(ns1);
        EBContext ebContext = EBContext.getContext();
        JDomUtils.addChild((Element)Othr, (String)"Id", (String)ebContext.getParameter().getBankParameter("CONNECT_CUSTOMER_ID")).setNamespace(ns1);
        Element PmtInf = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"PmtInf").setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtInfId", (String)paymentInfo.getBankBatchSeqID()).setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtMtd", (String)"TRF").setNamespace(ns1);
        Element PmtTpInf = JDomUtils.addChild((Element)PmtInf, (String)"PmtTpInf").setNamespace(ns1);
        Element SvcLvl = JDomUtils.addChild((Element)PmtTpInf, (String)"SvcLvl").setNamespace(ns1);
        JDomUtils.addChild((Element)SvcLvl, (String)"Cd", (String)"URGP").setNamespace(ns1);
        Element Dbtr = JDomUtils.addChild((Element)PmtInf, (String)"Dbtr").setNamespace(ns1);
        JDomUtils.addChild((Element)Dbtr, (String)"Nm", (String)"Hutchsion Telecommunications (Hong Kong) Limited").setNamespace(ns1);
        Element PstlAdr = JDomUtils.addChild((Element)Dbtr, (String)"PstlAdr").setNamespace(ns1);
        JDomUtils.addChild((Element)PstlAdr, (String)"StrtNm", (String)"15/F, Hutchison Telecom Tower").setNamespace(ns1);
        JDomUtils.addChild((Element)PstlAdr, (String)"Ctry", (String)"HK").setNamespace(ns1);
        Element DbtrAcct = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAcct").setNamespace(ns1);
        Element DbtrAcct_Id = JDomUtils.addChild((Element)DbtrAcct, (String)"Id").setNamespace(ns1);
        Element DbtrAcct_Othr = JDomUtils.addChild((Element)DbtrAcct_Id, (String)"Othr").setNamespace(ns1);
        JDomUtils.addChild((Element)DbtrAcct_Othr, (String)"Id", (String)paymentInfo.getAccNo()).setNamespace(ns1);
        JDomUtils.addChild((Element)DbtrAcct, (String)"Ccy", (String)paymentInfo.getPayCurrency()).setNamespace(ns1);
        Element DbtrAgt = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAgt").setNamespace(ns1);
        Element FinInstnId = JDomUtils.addChild((Element)DbtrAgt, (String)"FinInstnId").setNamespace(ns1);
        JDomUtils.addChild((Element)FinInstnId, (String)"BIC", (String)"HSBCHKHH").setNamespace(ns1);
        JDomUtils.addChild((Element)FinInstnId, (String)"Nm", (String)"THE HONGKONG AND SHANGHAI BANKING CORPORATION LTD").setNamespace(ns1);
        Element FinInstnId_PstlAdr = JDomUtils.addChild((Element)FinInstnId, (String)"PstlAdr").setNamespace(ns1);
        JDomUtils.addChild((Element)FinInstnId_PstlAdr, (String)"Ctry", (String)"HK").setNamespace(ns1);
        BigDecimal totalAmount = new BigDecimal("0.00");
        for (PaymentInfo item : paymentInfos) {
            Element CdtTrfTxInf = JDomUtils.addChild((Element)PmtInf, (String)"CdtTrfTxInf").setNamespace(ns1);
            Element PmtId = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"PmtId").setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"InstrId", (String)item.getBankDetailSeqID()).setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"EndToEndId", (String)item.getBankDetailSeqID()).setNamespace(ns1);
            Element Amt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Amt").setNamespace(ns1);
            Element InstdAmt = JDomUtils.addChild((Element)Amt, (String)"InstdAmt", (String)item.getAmount().toString()).setNamespace(ns1);
            totalAmount = totalAmount.add(item.getAmount());
            InstdAmt.setAttribute("Ccy", paymentInfo.getCurrency());
            JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)paymentInfo.getFeeType()).setNamespace(ns1);
            Element CdtrAgt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAgt").setNamespace(ns1);
            Element CdtrAgt_FinInstnId = JDomUtils.addChild((Element)CdtrAgt, (String)"FinInstnId").setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"BIC", (String)paymentInfo.getIncomeSwiftCode()).setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"Nm", (String)paymentInfo.getIncomeBankName()).setNamespace(ns1);
            Element CdtrAgt_FinInstnId_PstlAdr = JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"PstlAdr").setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId_PstlAdr, (String)"Ctry", (String)paymentInfo.getIncomeCountry()).setNamespace(ns1);
            Element Cdtr = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Cdtr").setNamespace(ns1);
            JDomUtils.addChild((Element)Cdtr, (String)"Nm", (String)paymentInfo.getIncomeAccName()).setNamespace(ns1);
            Element Cdtr_PstlAdr = JDomUtils.addChild((Element)Cdtr, (String)"PstlAdr").setNamespace(ns1);
            String payeeAddress = "HYATT REGENCY HONG KONG TST, 18 HANOI ROAD,TSIM SHA TSUI,HK";
            PaymentUtil.addressSplit(Cdtr_PstlAdr, payeeAddress);
            JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"Ctry", (String)paymentInfo.getIncomeCountry()).setNamespace(ns1);
            Element CdtrAcct = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAcct").setNamespace(ns1);
            Element CdtrAcct_Id = JDomUtils.addChild((Element)CdtrAcct, (String)"Id").setNamespace(ns1);
            Element CdtrAcct_Id_Othr = JDomUtils.addChild((Element)CdtrAcct_Id, (String)"Othr").setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAcct_Id_Othr, (String)"Id", (String)paymentInfo.getIncomeAccNo()).setNamespace(ns1);
            Element RmtInf = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RmtInf").setNamespace(ns1);
            JDomUtils.addChild((Element)RmtInf, (String)"Ustrd", (String)item.getExplanation()).setNamespace(ns1);
        }
        CtrlSum.addContent(totalAmount.toString());
        return JDomUtils.root2String((Element)root, (String)ebContext.getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return HSBC_DC_Parser.parsePayResponse(request, responseStr);
    }
}

