/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.cmp;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BankBusinessConfig
extends BankPropertyConfig {
    public static final PropertyConfigItem HSBC_CMP_BICCODE = PropertyConfigItem.builder().key("HSBC_CMP_BICCODE").mlName(new MultiLangEnumBridge("SWIFT CODE", "BankBusinessConfig_0", "ebg-aqap-banks-hsbc-cmp")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("SWFIT Code\uff08\u94f6\u884c\u56fd\u9645\u4ee3\u7801\uff09\uff1a\u8de8\u5883\u652f\u4ed8/\u5883\u5185\u5916\u5e01\u4e1a\u52a1\u4f7f\u7528\uff0c\u901a\u5e38\u75318\u621611\u4f4d\u6570\u5b57\u548c\u5b57\u6bcd\u7ec4\u6210\u3002", "BankBusinessConfig_14", "ebg-aqap-banks-hsbc-cmp"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u4f7f\u7528\u4ed8\u6b3e\u63a5\u53e3\u6709\uff1aACH\u3001CHECK\u3001PP\u63a5\u53e3\u3002", "BankBusinessConfig_15", "ebg-aqap-banks-hsbc-cmp")})).isAccNo(true).build();
    public static final PropertyConfigItem HSBC_CMP_BANKNAME = PropertyConfigItem.builder().key("HSBC_CMP_BANKNAME").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u94f6\u884c\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_1", "ebg-aqap-banks-hsbc-cmp")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u94f6\u884c\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_1", "ebg-aqap-banks-hsbc-cmp")})).isAccNo(true).defaultValues((List)Lists.newArrayList((Object[])new String[]{"THE HONGKONG AND SHANGHAI BANKING CORPORATION LTD"})).build();
    public static final PropertyConfigItem HSBC_CMP_PAY_COMPANY_ACNT = PropertyConfigItem.builder().key("HSBC_CMP_PAY_COMPANY_ACNT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_2", "ebg-aqap-banks-hsbc-cmp")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_2", "ebg-aqap-banks-hsbc-cmp")})).isAccNo(true).build();
    public static final PropertyConfigItem HSBC_CMP_PAY_COMPANY_STREET_ACNT = PropertyConfigItem.builder().key("HSBC_CMP_PAY_COMPANY_STREET_ACNT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u8857\u9053\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_3", "ebg-aqap-banks-hsbc-cmp")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u8857\u9053\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_3", "ebg-aqap-banks-hsbc-cmp")})).isAccNo(true).build();
    public static final PropertyConfigItem HSBC_CMP_PAY_COMPANY_CTRY_ACNT = PropertyConfigItem.builder().key("HSBC_CMP_PAY_COMPANY_CTRY_ACNT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u56fd\u5bb6\u6216\u5730\u533a\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_4", "ebg-aqap-banks-hsbc-cmp")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u56fd\u5bb6\u6216\u5730\u533a\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_4", "ebg-aqap-banks-hsbc-cmp")})).isAccNo(true).build();
    private static final PropertyConfigItem HSBC_CMP_BATCH_NUMBER = PropertyConfigItem.builder().key("HSBC_CMP_BATCH_NUMBER").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u6587\u4ef6\u4ed8\u6b3e\u7b14\u6570\u4e0a\u9650\u3002", "BankBusinessConfig_5", "ebg-aqap-banks-hsbc-cmp")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u914d\u7f6e\u8be5\u53c2\u6570\u540e\uff0c\u94f6\u4f01\u4e91\u5c06\u6309\u7167\u914d\u7f6e\u503c\u8bbe\u7f6e\u6279\u6b21\u5927\u5c0f\u3002\u4e0d\u8bbe\u7f6e\u5219\u9ed8\u8ba4100\u3002", "BankBusinessConfig_6", "ebg-aqap-banks-hsbc-cmp")})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"100"})).build();
    public static final PropertyConfigItem DBRT_ID = PropertyConfigItem.builder().key("DBRT_ID").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u5408\u540c\u7f16\u53f7", "BankBusinessConfig_7", "ebg-aqap-banks-hsbc-cmp")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("ACH\u4ed8\u6b3e\u5408\u540c\u7f16\u53f7\uff0c\u5982\u6709\u591a\u4e2a\uff0c\u53ef\u4ee5\u7528\u9017\u53f7\u5206\u9694\u3002", "BankBusinessConfig_8", "ebg-aqap-banks-hsbc-cmp")})).isAccNo(true).build();
    public static final PropertyConfigItem HSBC_CMP_PAY_PROTOCOL = PropertyConfigItem.builder().key("HSBC_CMP_PAY_PROTOCOL").mlName(new MultiLangEnumBridge("\u7528\u6237\u4e0e\u94f6\u884c\u7b7e\u8ba2\u7684\u534f\u8bae", "BankBusinessConfig_9", "ebg-aqap-banks-hsbc-cmp")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u7528\u6237\u4f7f\u7528\u7684\u534f\u8bae\uff0c\u5982AUTH", "BankBusinessConfig_10", "ebg-aqap-banks-hsbc-cmp")})).build();
    public static final PropertyConfigItem HSBC_CMP_PAY_COMPANY = PropertyConfigItem.builder().key("HSBC_CMP_PAY_COMPANY").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0", "BankBusinessConfig_11", "ebg-aqap-banks-hsbc-cmp")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_2", "ebg-aqap-banks-hsbc-cmp")})).build();
    public static final PropertyConfigItem HSBC_CMP_PAY_COMPANY_STREET = PropertyConfigItem.builder().key("HSBC_CMP_PAY_COMPANY_STREET").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u8857\u9053\u540d", "BankBusinessConfig_12", "ebg-aqap-banks-hsbc-cmp")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u8857\u9053\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_3", "ebg-aqap-banks-hsbc-cmp")})).build();
    public static final PropertyConfigItem HSBC_CMP_PAY_COMPANY_CTRY = PropertyConfigItem.builder().key("HSBC_CMP_PAY_COMPANY_CTRY").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u56fd\u5bb6\u6216\u5730\u533a\u3002", "BankBusinessConfig_13", "ebg-aqap-banks-hsbc-cmp")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u56fd\u5bb6\u6216\u5730\u533a\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_4", "ebg-aqap-banks-hsbc-cmp")})).build();
    private static final PropertyConfigItem HSBC_CMP_PAY_STATE_TIMEOUT = PropertyConfigItem.builder().key("HSBC_CMP_PAY_STATE_TIMEOUT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u72b6\u6001\u8d85\u65f6\u65f6\u95f4\u3002", "BankBusinessConfig_7", "ebg-aqap-banks-hsbc-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u63d0\u4ea4\u8d85\u8fc7\u914d\u7f6e\u7684\u65f6\u95f4\u672a\u5f97\u5230\u94f6\u884c\u54cd\u5e94\uff0c\u5c06\u4ed8\u6b3e\u72b6\u6001\u7f6e\u4e3a\u4ea4\u6613\u672a\u786e\u8ba4\u3002\u914d\u7f6e\u5927\u4e8e0\u7684\u6570\u5b57\uff0c\u5355\u4f4d\uff1a\u5c0f\u65f6\u3002\u4e0d\u8bbe\u7f6e\u5219\u4e0d\u4fee\u6539\u4ea4\u6613\u72b6\u6001\u3002", "BankBusinessConfig_8", "ebg-aqap-banks-hsbc-dc")})).build();

    public boolean isForeignBank() {
        return true;
    }

    public static List<String> getDBRTID(String accNo) {
        return DBRT_ID.getCurrentValuesWithObjectID(accNo);
    }

    public static int getBatchNumber() {
        String number = HSBC_CMP_BATCH_NUMBER.getCurrentValue();
        return Integer.parseInt(number);
    }

    public static String getPayCompany() {
        return HSBC_CMP_PAY_COMPANY.getCurrentValue();
    }

    public static String getPayCompanyStreet() {
        return HSBC_CMP_PAY_COMPANY_STREET.getCurrentValue();
    }

    public static String getPayCompanyCTRY() {
        return HSBC_CMP_PAY_COMPANY_CTRY.getCurrentValue();
    }

    public static String getPayProtocol() {
        return HSBC_CMP_PAY_PROTOCOL.getCurrentValue();
    }

    public static String getBicCode(String accNo) {
        return HSBC_CMP_BICCODE.getCurrentValueWithObjectID(accNo);
    }

    public static String getBankName(String accNo) {
        return HSBC_CMP_BANKNAME.getCurrentValueWithObjectID(accNo);
    }

    public static String getPayCompanyName(String accNo) {
        return HSBC_CMP_PAY_COMPANY_ACNT.getCurrentValueWithObjectID(accNo);
    }

    public static String getPayStreetName(String accNo) {
        return HSBC_CMP_PAY_COMPANY_STREET_ACNT.getCurrentValueWithObjectID(accNo);
    }

    public static String getPayCountryName(String accNo) {
        return HSBC_CMP_PAY_COMPANY_CTRY_ACNT.getCurrentValueWithObjectID(accNo);
    }

    public static String getCompany(String accNo) {
        String name = BankBusinessConfig.getPayCompanyName(accNo);
        if (StringUtils.isEmpty((String)name)) {
            return BankBusinessConfig.getPayCompany();
        }
        return name;
    }

    public static String getStreet(String accNo) {
        String name = BankBusinessConfig.getPayStreetName(accNo);
        if (StringUtils.isEmpty((String)name)) {
            return BankBusinessConfig.getPayCompanyStreet();
        }
        return name;
    }

    public static String getCountry(String accNo) {
        String name = BankBusinessConfig.getPayCountryName(accNo);
        if (StringUtils.isEmpty((String)name)) {
            return BankBusinessConfig.getPayCompanyCTRY();
        }
        return name;
    }

    public static int getPayStateTimeout() {
        String timeOut = HSBC_CMP_PAY_STATE_TIMEOUT.getCurrentValue();
        int timeout = 0;
        if (null != timeOut && timeOut.length() > 0) {
            try {
                if (Integer.parseInt(timeOut) > 0) {
                    timeout = Integer.parseInt(timeOut);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    public static boolean isPayStateTimeout(LocalDateTime submitSuccessTime) {
        int payStateTimeout = BankBusinessConfig.getPayStateTimeout();
        if (payStateTimeout <= 0) {
            return false;
        }
        LocalDateTime deadlineTime = submitSuccessTime.plus(payStateTimeout, ChronoUnit.HOURS);
        return deadlineTime.isBefore(LocalDateTime.now());
    }

    public String getBankVersionID() {
        return "HSBC_CMP";
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        ArrayList propertyConfigItems = Lists.newArrayList((Object[])new PropertyConfigItem[]{HSBC_CMP_BATCH_NUMBER, DBRT_ID, HSBC_CMP_BICCODE, HSBC_CMP_BANKNAME, HSBC_CMP_PAY_COMPANY_ACNT, HSBC_CMP_PAY_PROTOCOL, HSBC_CMP_PAY_COMPANY_STREET_ACNT, HSBC_CMP_PAY_COMPANY_CTRY_ACNT, HSBC_CMP_PAY_COMPANY, HSBC_CMP_PAY_COMPANY_STREET, HSBC_CMP_PAY_COMPANY_CTRY, HSBC_CMP_PAY_STATE_TIMEOUT});
        List<PropertyConfigItem> bankProp = this.getBankAddtionalPropertyConfigItems(false, false, false).stream().filter(f -> !f.getKey().equalsIgnoreCase("IS_RECEIPT_CHECK") && !f.getKey().equalsIgnoreCase("IS_AUTO_RETRY_DOWNLOAD")).collect(Collectors.toList());
        bankProp.addAll(propertyConfigItems);
        return bankProp;
    }
}

