/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayDepositBalBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DepositBalanceImpl
extends AbstractBalanceImpl
implements ITodayDepositBalBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt acnt = (BankAcnt)bankBalanceRequest.getBankAcntList().get(0);
        Element root = ABC_DC_Packer.createABCRoot4New("CQRA04", Sequence.genSequence());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)bankBalanceRequest.getBankCurrency());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (!"0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Element acc = root.getChild("Acc");
        String depositBal = ParserUtils.checkUnNullableElement((Element)acc, (String)"AvailBal");
        BalanceInfo balance = new BalanceInfo();
        this.setDepositBalance(balance, depositBal);
        balance.setBankAcnt(bankBalanceRequest.getAcnt());
        balance.setBankCurrency(bankBalanceRequest.getBankCurrency());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return "CQRA04";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2", (String)"DepositBalanceImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceRequest request) {
        LocalDate today = LocalDate.now();
        boolean matchTime = today.equals(request.getStartDate()) && today.equals(request.getEndDate());
        boolean matchConfig = BankBusinessConfig.isQueryDepositBal(((BankAcnt)request.getBankAcntList().get(0)).getAccNo());
        String accType = BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo());
        boolean accTypeBoolean = !"tzck".equalsIgnoreCase(accType.trim());
        return matchTime && matchConfig && accTypeBoolean;
    }
}

