/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        String accType = BankAcntPropertyConfig.getAccType((String)acnt.getAccNo());
        if ("tzck".equalsIgnoreCase(accType.trim())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u901a\u77e5\u5b58\u6b3e\u6237\u4e0d\u652f\u6301\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u3002", (String)"", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        }
        Element root = ABC_DC_Packer.createABCRoot4New("CQRC17", Sequence.genSequence());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)request.getBankCurrency());
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"StartDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)corp, (String)"EndDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String[] splits;
        Element root = ABC_DC_Parser.parseString2Root(responseStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (!"0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Element cmp = root.getChild("Cmp");
        Element cme = root.getChild("Cme");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            return new EBBankBalanceResponse((List)Lists.newArrayListWithCapacity((int)1));
        }
        String fileFlag = ParserUtils.checkUnNullableElement((Element)root, (String)"FileFlag");
        if ("1".equalsIgnoreCase(fileFlag)) {
            String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
            splits = ResponseFileUtils.getBalanceRspRecords(fileName, "");
        } else {
            String respPrvData = ParserUtils.checkUnNullableElement((Element)cmp, (String)"RespPrvData");
            splits = StringUtils.split((String)respPrvData, (String)"|");
        }
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        int fieldNum = Integer.parseInt(fieldNumStr);
        ArrayList<BalanceInfo> resultList = new ArrayList<BalanceInfo>(recordNum);
        for (int i = 0; i < recordNum; ++i) {
            BalanceInfo balance = new BalanceInfo();
            balance.setBankAcnt(request.getAcnt());
            balance.setBankCurrency(request.getBankCurrency());
            resultList.add(balance);
            String dateStr = splits[fieldNum * i + 0];
            this.setBalanceDateTime(balance, dateStr + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            String balanceStr = splits[fieldNum * i + 1];
            this.setCurrentBalance(balance, balanceStr);
            String availableBalanceStr = "";
            availableBalanceStr = splits[fieldNum * i + 2];
            this.setAvailableBalance(balance, availableBalanceStr);
        }
        return new EBBankBalanceResponse(resultList);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "CQRC17";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"CQRC17(\u5386\u53f2\u4f59\u989d)", (String)"HisBalanceImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceRequest request) {
        return !BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo()) && !BankBusinessConfig.isAggregatorsAcnt(request.getAcnt().getAccNo());
    }

    public int queryDays() {
        return 31;
    }
}

